/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.remote.http.whiteboard.debug.osgi.commands;

import com.liferay.petra.string.StringBundler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.http.runtime.HttpServiceRuntime;
import org.osgi.service.http.runtime.dto.RuntimeDTO;
import org.osgi.service.http.runtime.dto.ServletContextDTO;

@Component(property={"osgi.command.function=check", "osgi.command.scope=http"}, service={HttpServiceRuntimeOSGiCommands.class})
public class HttpServiceRuntimeOSGiCommands {
    private BundleContext _bundleContext;
    @Reference
    private HttpServiceRuntime _httpServiceRuntime;

    public void check() {
        RuntimeDTO runtimeDTO = this._httpServiceRuntime.getRuntimeDTO();
        HashMap<String, Set> contextPathMap = new HashMap<String, Set>();
        for (ServletContextDTO servletContextDTO : runtimeDTO.servletContextDTOs) {
            Set servletContextDTOs = contextPathMap.computeIfAbsent(servletContextDTO.contextPath, key -> new HashSet());
            servletContextDTOs.add(servletContextDTO);
        }
        for (Set servletContextDTOs : contextPathMap.values()) {
            if (servletContextDTOs.size() < 2) continue;
            TreeSet<Object> navigableSet = new TreeSet<Object>();
            for (ServletContextDTO servletContextDTO : servletContextDTOs) {
                navigableSet.add(this._getServiceReference(servletContextDTO.serviceId));
            }
            ServiceReference lastServiceReference = (ServiceReference)navigableSet.last();
            for (ServiceReference serviceReference : navigableSet.headSet(lastServiceReference, false)) {
                System.out.println(StringBundler.concat((Object[])new Object[]{"Servlet context with path ", serviceReference.getProperty("osgi.http.whiteboard.context.path"), " and service ID ", serviceReference.getProperty("service.id"), " might fail because it is shadowed by service ", lastServiceReference.getProperty("service.id")}));
            }
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    private ServiceReference<?> _getServiceReference(long serviceId) {
        try {
            ServiceReference[] serviceReferences = this._bundleContext.getServiceReferences((String)null, "(service.id=" + serviceId + ")");
            if (serviceReferences == null || serviceReferences.length == 0) {
                return null;
            }
            return serviceReferences[0];
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new IllegalArgumentException(invalidSyntaxException);
        }
    }
}

