/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.remote.jaxrs.whiteboard.internal.log;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.cxf.common.logging.AbstractDelegatingLogger;

public class LiferayCXFLogger
extends AbstractDelegatingLogger {
    private static final Log _classLog = LogFactoryUtil.getLog(LiferayCXFLogger.class);
    private final Level _level;
    private final Log _log;

    public LiferayCXFLogger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
        this._log = LogFactoryUtil.getLog((String)name);
        this._level = this._log.isTraceEnabled() ? Level.FINEST : (this._log.isDebugEnabled() ? Level.FINER : (this._log.isInfoEnabled() ? Level.INFO : (this._log.isWarnEnabled() ? Level.WARNING : (this._log.isErrorEnabled() ? Level.WARNING : Level.OFF))));
    }

    public Level getLevel() {
        return this._level;
    }

    protected void internalLogFormatted(String msg, LogRecord logRecord) {
        Level level = logRecord.getLevel();
        if (level == null) {
            this._logError(level, msg, logRecord);
            return;
        }
        if (level.equals(Level.CONFIG)) {
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)msg, logRecord.getThrown());
            }
        } else if (level.equals(Level.FINE)) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)msg, logRecord.getThrown());
            }
        } else if (level.equals(Level.FINER)) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)msg, logRecord.getThrown());
            }
        } else if (level.equals(Level.FINEST)) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)msg, logRecord.getThrown());
            }
        } else if (level.equals(Level.INFO)) {
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)msg, logRecord.getThrown());
            }
        } else if (level.equals(Level.SEVERE)) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)msg, logRecord.getThrown());
            }
        } else if (level.equals(Level.WARNING)) {
            if (this._log.isWarnEnabled()) {
                this._log.warn((Object)msg, logRecord.getThrown());
            }
        } else {
            this._logError(level, msg, logRecord);
        }
    }

    private void _logError(Level level, String msg, LogRecord logRecord) {
        if (!_classLog.isErrorEnabled()) {
            return;
        }
        if (level == null) {
            _classLog.error((Object)"Unable to map Log4j level: null");
        } else {
            _classLog.error((Object)("Unable to map Log4j level: " + level.getName()));
        }
        _classLog.error((Object)("Original message: " + msg), logRecord.getThrown());
    }
}

