/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.remote.jaxrs.whiteboard.internal.servlet.filter;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.remote.jaxrs.whiteboard.internal.servlet.filter.JAXRSActivationFilterTracker;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Application;
import org.osgi.framework.BundleContext;

public class JAXRSActivationFilter
implements Filter {
    private final BundleContext _bundleContext;
    private final JAXRSActivationFilterTracker _jaxrsActivationFilterTracker;
    private ServiceTrackerMap<String, Application> _serviceTrackerMap;

    public JAXRSActivationFilter(BundleContext bundleContext, JAXRSActivationFilterTracker jaxrsActivationFilterTracker) {
        this._bundleContext = bundleContext;
        this._jaxrsActivationFilterTracker = jaxrsActivationFilterTracker;
    }

    public void destroy() {
        this._serviceTrackerMap.close();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String key = GetterUtil.getString((Object)httpServletRequest.getAttribute("javax.servlet.include.path_info"), (String)httpServletRequest.getPathInfo());
        if (key != null) {
            int index = key.indexOf(47, 1);
            if (index != -1) {
                key = key.substring(0, index);
            }
            if (this._serviceTrackerMap.containsKey((Object)key) || this._serviceTrackerMap.containsKey((Object)"/")) {
                this._jaxrsActivationFilterTracker.setReady();
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void init(FilterConfig filterConfig) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)this._bundleContext, Application.class, (String)"(osgi.jaxrs.application.base=*)", (serviceReference, emitter) -> {
            String applicationBase = GetterUtil.getString((Object)serviceReference.getProperty("osgi.jaxrs.application.base"));
            int index = applicationBase.indexOf(47, 1);
            if (index == -1) {
                emitter.emit((Object)applicationBase);
            } else {
                emitter.emit((Object)applicationBase.substring(0, index));
            }
        });
    }
}

