/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.remote.json.web.service.extender.internal;

import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionsManager;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceRegistrator;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceRegistratorFactory;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceScannerStrategy;
import com.liferay.portal.remote.json.web.service.extender.internal.ServiceJSONWebServiceScannerStrategy;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={JSONWebServiceTracker.class})
public class JSONWebServiceTracker
implements ServiceTrackerCustomizer<Object, Object> {
    private ComponentContext _componentContext;
    private JSONWebServiceActionsManager _jsonWebServiceActionsManager;
    private JSONWebServiceRegistrator _jsonWebServiceRegistrator;
    private ServiceTracker<Object, Object> _serviceTracker;

    public Object addingService(ServiceReference<Object> serviceReference) {
        return this.registerService(serviceReference);
    }

    public void modifiedService(ServiceReference<Object> serviceReference, Object service) {
        this.unregisterService(service);
        this.registerService(serviceReference);
    }

    public void removedService(ServiceReference<Object> serviceReference, Object service) {
        this.unregisterService(service);
    }

    @Activate
    protected void activate(ComponentContext componentContext) {
        this._componentContext = componentContext;
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)componentContext.getBundleContext(), (String)StringBundler.concat((String[])new String[]{"(&(json.web.service.context.name=*)(json.web.service.context.", "path=*)(!(objectClass=", AopService.class.getName(), ")))"}), (ServiceTrackerCustomizer)this);
    }

    @Deactivate
    protected void deactivate() {
        this._componentContext = null;
        this._serviceTracker.close();
        this._serviceTracker = null;
    }

    protected ClassLoader getBundleClassLoader(Bundle bundle) {
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        return bundleWiring.getClassLoader();
    }

    protected Object getService(ServiceReference<Object> serviceReference) {
        BundleContext bundleContext = this._componentContext.getBundleContext();
        return bundleContext.getService(serviceReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object registerService(ServiceReference<Object> serviceReference) {
        String contextName = (String)serviceReference.getProperty("json.web.service.context.name");
        String contextPath = (String)serviceReference.getProperty("json.web.service.context.path");
        Object service = this.getService(serviceReference);
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        ClassLoader classLoader = this.getBundleClassLoader(serviceReference.getBundle());
        currentThread.setContextClassLoader(classLoader);
        try {
            this._jsonWebServiceActionsManager.registerService(contextName, contextPath, service, this._jsonWebServiceRegistrator);
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
        return service;
    }

    @Reference
    protected void setJSONWebServiceActionsManager(JSONWebServiceActionsManager jsonWebServiceActionsManager) {
        this._jsonWebServiceActionsManager = jsonWebServiceActionsManager;
    }

    @Reference
    protected void setJSONWebServiceRegistratorFactory(JSONWebServiceRegistratorFactory jsonWebServiceRegistratorFactory) {
        this._jsonWebServiceRegistrator = jsonWebServiceRegistratorFactory.build((JSONWebServiceScannerStrategy)new ServiceJSONWebServiceScannerStrategy());
    }

    protected void unregisterService(Object service) {
        this._jsonWebServiceActionsManager.unregisterJSONWebServiceActions(service);
    }

    protected void unsetJSONWebServiceActionsManager(JSONWebServiceActionsManager jsonWebServiceActionsManager) {
        this._jsonWebServiceActionsManager = null;
    }

    protected void unsetJSONWebServiceRegistratorFactory(JSONWebServiceRegistratorFactory jsonWebServiceRegistratorFactory) {
        this._jsonWebServiceRegistrator = null;
    }
}

