/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.remote.rest.extender.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.remote.rest.extender.configuration.RestExtenderConfiguration;
import com.liferay.portal.remote.rest.extender.internal.CXFJaxRsServiceRegistrator;
import java.util.Map;
import javax.ws.rs.core.Application;
import org.apache.cxf.Bus;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.ServiceDependency;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.runtime.JaxrsServiceRuntime;

@Component(configurationPid={"com.liferay.portal.remote.rest.extender.configuration.RestExtenderConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={})
public class RESTExtender {
    private org.apache.felix.dm.Component _component;
    private DependencyManager _dependencyManager;
    @Reference
    private JaxrsServiceRuntime _jaxrsServiceRuntime;
    private RestExtenderConfiguration _restExtenderConfiguration;

    public RestExtenderConfiguration getRestExtenderConfiguration() {
        return this._restExtenderConfiguration;
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._restExtenderConfiguration = (RestExtenderConfiguration)ConfigurableUtil.createConfigurable(RestExtenderConfiguration.class, properties);
        this._dependencyManager = new DependencyManager(bundleContext);
        this._component = this._dependencyManager.createComponent();
        CXFJaxRsServiceRegistrator cxfJaxRsServiceRegistrator = new CXFJaxRsServiceRegistrator(properties);
        this._component.setImplementation((Object)cxfJaxRsServiceRegistrator);
        this._addBusDependencies();
        this._addJaxRsApplicationDependencies();
        this._addJaxRsProviderServiceDependencies();
        this._addJaxRsServiceDependencies();
        this._dependencyManager.add(this._component);
    }

    @Deactivate
    protected void deactivate() {
        this._dependencyManager.clear();
    }

    private void _addBusDependencies() {
        RestExtenderConfiguration restExtenderConfiguration = this.getRestExtenderConfiguration();
        String[] contextPaths = restExtenderConfiguration.contextPaths();
        if (contextPaths == null) {
            return;
        }
        for (String contextPath : contextPaths) {
            if (Validator.isNull((String)contextPath)) continue;
            this._addTCCLServiceDependency(true, Bus.class, StringBundler.concat((String[])new String[]{"(", "osgi.http.whiteboard.context.path", "=", contextPath, ")"}), "addBus", "removeBus");
        }
    }

    private void _addJaxRsApplicationDependencies() {
        RestExtenderConfiguration restExtenderConfiguration = this.getRestExtenderConfiguration();
        String[] jaxRsApplicationFilterStrings = restExtenderConfiguration.jaxRsApplicationFilterStrings();
        if (jaxRsApplicationFilterStrings == null) {
            this._addTCCLServiceDependency(false, Application.class, null, "addApplication", "removeApplication");
            return;
        }
        for (String jaxRsApplicationFilterString : jaxRsApplicationFilterStrings) {
            this._addTCCLServiceDependency(false, Application.class, jaxRsApplicationFilterString, "addApplication", "removeApplication");
        }
    }

    private void _addJaxRsProviderServiceDependencies() {
        RestExtenderConfiguration soapExtenderConfiguration = this.getRestExtenderConfiguration();
        String[] jaxRsProviderFilterStrings = soapExtenderConfiguration.jaxRsProviderFilterStrings();
        if (jaxRsProviderFilterStrings == null) {
            return;
        }
        for (String jaxRsProviderFilterString : jaxRsProviderFilterStrings) {
            if (Validator.isNull((String)jaxRsProviderFilterString)) continue;
            this._addTCCLServiceDependency(false, null, jaxRsProviderFilterString, "addProvider", "removeProvider");
        }
    }

    private void _addJaxRsServiceDependencies() {
        RestExtenderConfiguration soapExtenderConfiguration = this.getRestExtenderConfiguration();
        String[] jaxRsServiceFilterStrings = soapExtenderConfiguration.jaxRsServiceFilterStrings();
        if (jaxRsServiceFilterStrings == null) {
            return;
        }
        for (String jaxRsServiceFilterString : jaxRsServiceFilterStrings) {
            if (Validator.isNull((String)jaxRsServiceFilterString)) continue;
            this._addTCCLServiceDependency(false, null, jaxRsServiceFilterString, "addService", "removeService");
        }
    }

    private ServiceDependency _addTCCLServiceDependency(boolean required, Class<?> clazz, String filter, String addName, String removeName) {
        ServiceDependency serviceDependency = this._dependencyManager.createServiceDependency();
        serviceDependency.setCallbacks(addName, removeName);
        serviceDependency.setRequired(required);
        if (clazz == null) {
            serviceDependency.setService(filter);
        } else if (filter == null) {
            serviceDependency.setService(clazz);
        } else {
            serviceDependency.setService(clazz, filter);
        }
        this._component.add(new Dependency[]{serviceDependency});
        return serviceDependency;
    }
}

