/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.remote.soap.extender.internal;

import com.liferay.portal.remote.soap.extender.SoapDescriptorBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.xml.namespace.QName;
import javax.xml.ws.Binding;
import javax.xml.ws.handler.Handler;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;

public class CXFJaxWsServiceRegistrator {
    private final Collection<Bus> _buses = new ArrayList<Bus>();
    private final Map<Bus, Map<Object, Server>> _busServers = new IdentityHashMap<Bus, Map<Object, Server>>();
    private final List<Handler> _handlers = new ArrayList<Handler>();
    private final Map<Object, Map<String, Object>> _serviceProperties = new IdentityHashMap<Object, Map<String, Object>>();
    private SoapDescriptorBuilder _soapDescriptorBuilder;

    public synchronized void addBus(Bus bus) {
        this._swapClassLoader(bus, this::_addBus);
    }

    public synchronized void addHandler(Handler<?> handler) {
        this._swapClassLoader(handler, this::_addHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addService(Map<String, Object> properties, Object service) {
        Class<?> clazz = service.getClass();
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(clazz.getClassLoader());
            this._addService(properties, service);
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }

    public synchronized void removeBus(Bus bus) {
        this._swapClassLoader(bus, this::_removeBus);
    }

    public synchronized void removeHandler(Handler<?> handler) {
        this._swapClassLoader(handler, this::_removeHandler);
    }

    public synchronized void removeService(Object service) {
        this._swapClassLoader(service, this::_removeService);
    }

    public void setSoapDescriptorBuilder(SoapDescriptorBuilder soapDescriptorBuilder) {
        this._soapDescriptorBuilder = soapDescriptorBuilder;
    }

    protected void registerService(Bus bus, Object service, Map<String, Object> properties) {
        String wsdlLocation;
        JaxWsServerFactoryBean jaxWsServerFactoryBean = new JaxWsServerFactoryBean();
        SoapDescriptorBuilder.SoapDescriptor soapDescriptor = this._soapDescriptorBuilder.buildSoapDescriptor(service, properties);
        jaxWsServerFactoryBean.setAddress(soapDescriptor.getPublicationAddress());
        jaxWsServerFactoryBean.setBus(bus);
        QName endpointName = soapDescriptor.getEndpointName();
        if (endpointName != null) {
            jaxWsServerFactoryBean.setEndpointName(endpointName);
        }
        jaxWsServerFactoryBean.setHandlers(this._handlers);
        jaxWsServerFactoryBean.setProperties(properties);
        jaxWsServerFactoryBean.setServiceBean(service);
        Class serviceClass = soapDescriptor.getServiceClass();
        if (serviceClass != null) {
            jaxWsServerFactoryBean.setServiceClass(serviceClass);
        }
        if ((wsdlLocation = soapDescriptor.getWsdlLocation()) != null) {
            jaxWsServerFactoryBean.setWsdlLocation(wsdlLocation);
        }
        Server server = jaxWsServerFactoryBean.create();
        this.store(bus, server, service);
    }

    protected void store(Bus bus, Server server, Object service) {
        Map<Object, Server> servers = this._busServers.get(bus);
        if (servers == null) {
            servers = new HashMap<Object, Server>();
            this._busServers.put(bus, servers);
        }
        servers.put(service, server);
    }

    private void _addBus(Bus bus) {
        this._buses.add(bus);
        for (Map.Entry<Object, Map<String, Object>> entry : this._serviceProperties.entrySet()) {
            this.registerService(bus, entry.getKey(), entry.getValue());
        }
    }

    private void _addHandler(Handler<?> handler) {
        this._handlers.add(handler);
        for (Map<Object, Server> servers : this._busServers.values()) {
            for (Server server : servers.values()) {
                JaxWsEndpointImpl jaxWsEndpointImpl = (JaxWsEndpointImpl)server.getEndpoint();
                Binding binding = jaxWsEndpointImpl.getJaxwsBinding();
                List handlers = binding.getHandlerChain();
                handlers.add(handler);
                binding.setHandlerChain(handlers);
            }
        }
    }

    private void _addService(Map<String, Object> properties, Object service) {
        for (Bus bus : this._buses) {
            this.registerService(bus, service, properties);
        }
        this._serviceProperties.put(service, properties);
    }

    private void _removeBus(Bus bus) {
        this._buses.remove(bus);
        Map<Object, Server> servers = this._busServers.remove(bus);
        if (servers == null) {
            return;
        }
        for (Server server : servers.values()) {
            server.destroy();
        }
    }

    private void _removeHandler(Handler<?> handler) {
        for (Map<Object, Server> servers : this._busServers.values()) {
            for (Server server : servers.values()) {
                JaxWsEndpointImpl jaxWsEndpointImpl = (JaxWsEndpointImpl)server.getEndpoint();
                Binding binding = jaxWsEndpointImpl.getJaxwsBinding();
                List handlers = binding.getHandlerChain();
                handlers.remove(handler);
                binding.setHandlerChain(handlers);
            }
        }
        this._handlers.remove(handler);
    }

    private void _removeService(Object service) {
        this._serviceProperties.remove(service);
        for (Map<Object, Server> servers : this._busServers.values()) {
            Server server = servers.get(service);
            if (server == null) continue;
            server.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void _swapClassLoader(T t, Consumer<T> consumer) {
        Class<?> clazz = t.getClass();
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(clazz.getClassLoader());
            consumer.accept(t);
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }
}

