/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.remote.soap.extender.internal;

import com.liferay.portal.remote.soap.extender.SoapDescriptorBuilder;
import java.util.Map;
import javax.xml.namespace.QName;
import org.osgi.service.component.annotations.Component;

@Component(service={SoapDescriptorBuilder.class})
public class DefaultSoapDescriptorBuilder
implements SoapDescriptorBuilder {
    public SoapDescriptorBuilder.SoapDescriptor buildSoapDescriptor(Object service, Map<String, Object> properties) {
        return new DefaultSoapDescriptor(service, properties);
    }

    private static class DefaultSoapDescriptor
    implements SoapDescriptorBuilder.SoapDescriptor {
        private final Map<String, Object> _properties;
        private final Object _service;

        public DefaultSoapDescriptor(Object service, Map<String, Object> properties) {
            this._service = service;
            this._properties = properties;
        }

        public QName getEndpointName() {
            Object soapEndpointName = this._properties.get("soap.endpoint.name");
            if (soapEndpointName != null && soapEndpointName instanceof QName) {
                return (QName)soapEndpointName;
            }
            return null;
        }

        public String getPublicationAddress() {
            Object soapAddress = this._properties.get("soap.address");
            if (soapAddress == null) {
                Class<?> clazz = this._service.getClass();
                return "/" + clazz.getSimpleName();
            }
            return soapAddress.toString();
        }

        public Class<?> getServiceClass() {
            Object soapServiceClass = this._properties.get("soap.service.class");
            if (soapServiceClass != null && soapServiceClass instanceof Class) {
                return (Class)soapServiceClass;
            }
            return null;
        }

        public String getWsdlLocation() {
            Object soapWsdlLocation = this._properties.get("soap.wsdl.location");
            if (soapWsdlLocation != null) {
                return soapWsdlLocation.toString();
            }
            return null;
        }
    }
}

