/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.remote.soap.extender.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.remote.soap.extender.SoapDescriptorBuilder;
import com.liferay.portal.remote.soap.extender.internal.CXFJaxWsServiceRegistrator;
import com.liferay.portal.remote.soap.extender.internal.configuration.SoapExtenderConfiguration;
import java.util.Map;
import javax.xml.ws.handler.Handler;
import org.apache.cxf.Bus;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.ServiceDependency;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.liferay.portal.remote.soap.extender.internal.configuration.SoapExtenderConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={})
public class SoapExtender {
    private DependencyManager _dependencyManager;
    private SoapDescriptorBuilder _soapDescriptorBuilder;
    private volatile SoapExtenderConfiguration _soapExtenderConfiguration;

    public SoapExtenderConfiguration getSoapExtenderConfiguration() {
        return this._soapExtenderConfiguration;
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._soapExtenderConfiguration = (SoapExtenderConfiguration)ConfigurableUtil.createConfigurable(SoapExtenderConfiguration.class, properties);
        this._dependencyManager = new DependencyManager(bundleContext);
        this._enableComponent();
    }

    protected void addBusDependencies(org.apache.felix.dm.Component component) {
        SoapExtenderConfiguration soapExtenderConfiguration = this.getSoapExtenderConfiguration();
        String[] contextPaths = soapExtenderConfiguration.contextPaths();
        if (contextPaths == null) {
            return;
        }
        for (String contextPath : contextPaths) {
            this.addTCCLServiceDependency(component, true, Bus.class, StringBundler.concat((String[])new String[]{"(", "osgi.http.whiteboard.context.path", "=", contextPath, ")"}), "addBus", "removeBus");
        }
    }

    protected void addJaxWsHandlerServiceDependencies(org.apache.felix.dm.Component component) {
        SoapExtenderConfiguration soapExtenderConfiguration = this.getSoapExtenderConfiguration();
        String[] jaxWsHandlerFilterStrings = soapExtenderConfiguration.jaxWsHandlerFilterStrings();
        if (jaxWsHandlerFilterStrings == null) {
            return;
        }
        for (String jaxWsHandlerFilterString : jaxWsHandlerFilterStrings) {
            this.addTCCLServiceDependency(component, false, Handler.class, jaxWsHandlerFilterString, "addHandler", "removeHandler");
        }
    }

    protected void addJaxWsServiceDependencies(org.apache.felix.dm.Component component) {
        SoapExtenderConfiguration soapExtenderConfiguration = this.getSoapExtenderConfiguration();
        String[] jaxWsServiceFilterStrings = soapExtenderConfiguration.jaxWsServiceFilterStrings();
        if (jaxWsServiceFilterStrings == null) {
            return;
        }
        for (String jaxWsServiceFilterString : jaxWsServiceFilterStrings) {
            this.addTCCLServiceDependency(component, false, null, jaxWsServiceFilterString, "addService", "removeService");
        }
    }

    protected void addSoapDescriptorBuilderServiceDependency(org.apache.felix.dm.Component component) {
        ServiceDependency serviceDependency = this._dependencyManager.createServiceDependency();
        serviceDependency.setCallbacks("setSoapDescriptorBuilder", null);
        serviceDependency.setRequired(false);
        serviceDependency.setService(SoapDescriptorBuilder.class, this._soapExtenderConfiguration.soapDescriptorBuilderFilter());
        component.add(new Dependency[]{serviceDependency});
    }

    protected ServiceDependency addTCCLServiceDependency(org.apache.felix.dm.Component component, boolean required, Class<?> clazz, String filterString, String addName, String removeName) {
        ServiceDependency serviceDependency = this._dependencyManager.createServiceDependency();
        serviceDependency.setCallbacks(addName, removeName);
        serviceDependency.setRequired(required);
        if (clazz == null) {
            serviceDependency.setService(filterString);
        } else {
            serviceDependency.setService(clazz, filterString);
        }
        component.add(new Dependency[]{serviceDependency});
        return serviceDependency;
    }

    @Deactivate
    protected void deactivate() {
        this._dependencyManager.clear();
    }

    @Modified
    protected void modified(BundleContext bundleContext, Map<String, Object> properties) {
        this.deactivate();
        this.activate(bundleContext, properties);
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setSoapDescriptorBuilder(SoapDescriptorBuilder soapDescriptorBuilder) {
        this._soapDescriptorBuilder = soapDescriptorBuilder;
        if (this._dependencyManager != null) {
            this._dependencyManager.clear();
            this._enableComponent();
        }
    }

    protected void unsetSoapDescriptorBuilder(SoapDescriptorBuilder soapDescriptorBuilder) {
    }

    private void _enableComponent() {
        org.apache.felix.dm.Component component = this._dependencyManager.createComponent();
        CXFJaxWsServiceRegistrator cxfJaxWsServiceRegistrator = new CXFJaxWsServiceRegistrator();
        cxfJaxWsServiceRegistrator.setSoapDescriptorBuilder(this._soapDescriptorBuilder);
        component.setImplementation((Object)cxfJaxWsServiceRegistrator);
        this.addBusDependencies(component);
        this.addJaxWsHandlerServiceDependencies(component);
        this.addJaxWsServiceDependencies(component);
        this.addSoapDescriptorBuilderServiceDependency(component);
        this._dependencyManager.add(component);
    }
}

