/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.internal;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFileShortcutException;
import com.liferay.document.library.kernel.exception.NoSuchFileVersionException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryService;
import com.liferay.document.library.kernel.service.DLFileShortcutLocalService;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchRepositoryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.RepositoryEntry;
import com.liferay.portal.kernel.repository.InvalidRepositoryIdException;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.RepositoryFactory;
import com.liferay.portal.kernel.repository.RepositoryProvider;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionRegistryUtil;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RepositoryEntryLocalService;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={RepositoryProvider.class})
public class RepositoryProviderImpl
implements RepositoryProvider {
    private static final Log _log = LogFactoryUtil.getLog(RepositoryProviderImpl.class);
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private DLFileEntryService _dlFileEntryService;
    @Reference
    private DLFileShortcutLocalService _dlFileShortcutLocalService;
    @Reference
    private DLFileVersionLocalService _dlFileVersionLocalService;
    @Reference
    private DLFolderLocalService _dlFolderLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private RepositoryEntryLocalService _repositoryEntryLocalService;
    @Reference(target="(original.bean=true)")
    private RepositoryFactory _repositoryFactory;
    @Reference
    private RepositoryLocalService _repositoryLocalService;

    public LocalRepository fetchFileEntryLocalRepository(long fileEntryId) throws PortalException {
        long repositoryId = this.fetchFileEntryRepositoryId(fileEntryId);
        if (repositoryId != -1L) {
            try {
                return this.getLocalRepository(repositoryId);
            }
            catch (InvalidRepositoryIdException invalidRepositoryIdException) {
                throw new NoSuchFileEntryException(StringBundler.concat((Object[])new Object[]{"No FileEntry exists with the key {fileEntryId=", fileEntryId, "}"}), (Throwable)invalidRepositoryIdException);
            }
        }
        return null;
    }

    public LocalRepository getFileEntryLocalRepository(long fileEntryId) throws PortalException {
        try {
            return this.getLocalRepository(this.getFileEntryRepositoryId(fileEntryId));
        }
        catch (InvalidRepositoryIdException invalidRepositoryIdException) {
            throw new NoSuchFileEntryException(StringBundler.concat((Object[])new Object[]{"No FileEntry exists with the key {fileEntryId=", fileEntryId, "}"}), (Throwable)invalidRepositoryIdException);
        }
    }

    public com.liferay.portal.kernel.repository.Repository getFileEntryRepository(long fileEntryId) throws PortalException {
        try {
            this.checkFileEntryPermissions(fileEntryId);
            return this.getRepository(this.getFileEntryRepositoryId(fileEntryId));
        }
        catch (InvalidRepositoryIdException invalidRepositoryIdException) {
            throw new NoSuchFileEntryException(StringBundler.concat((Object[])new Object[]{"No FileEntry exists with the key {fileEntryId=", fileEntryId, "}"}), (Throwable)invalidRepositoryIdException);
        }
    }

    public LocalRepository getFileShortcutLocalRepository(long fileShortcutId) throws PortalException {
        try {
            return this.getLocalRepository(this.getFileShortcutRepositoryId(fileShortcutId));
        }
        catch (InvalidRepositoryIdException invalidRepositoryIdException) {
            throw new NoSuchFileShortcutException(StringBundler.concat((Object[])new Object[]{"No FileShortcut exists with the key {fileShortcutId=", fileShortcutId, "}"}), (Throwable)invalidRepositoryIdException);
        }
    }

    public com.liferay.portal.kernel.repository.Repository getFileShortcutRepository(long fileShortcutId) throws PortalException {
        try {
            this.checkFileShortcutPermissions(fileShortcutId);
            return this.getRepository(this.getFileShortcutRepositoryId(fileShortcutId));
        }
        catch (InvalidRepositoryIdException invalidRepositoryIdException) {
            throw new NoSuchFileShortcutException(StringBundler.concat((Object[])new Object[]{"No FileShortcut exists with the key {fileShortcutId=", fileShortcutId, "}"}), (Throwable)invalidRepositoryIdException);
        }
    }

    public LocalRepository getFileVersionLocalRepository(long fileVersionId) throws PortalException {
        try {
            return this.getLocalRepository(this.getFileVersionRepositoryId(fileVersionId));
        }
        catch (InvalidRepositoryIdException invalidRepositoryIdException) {
            throw new NoSuchFileVersionException(StringBundler.concat((Object[])new Object[]{"No FileVersion exists with the key {fileVersionId=", fileVersionId, "}"}), (Throwable)invalidRepositoryIdException);
        }
    }

    public com.liferay.portal.kernel.repository.Repository getFileVersionRepository(long fileVersionId) throws PortalException {
        try {
            this.checkFileVersionPermissions(fileVersionId);
            return this.getRepository(this.getFileVersionRepositoryId(fileVersionId));
        }
        catch (InvalidRepositoryIdException invalidRepositoryIdException) {
            throw new NoSuchFileVersionException(StringBundler.concat((Object[])new Object[]{"No FileVersion exists with the key {fileVersionId=", fileVersionId, "}"}), (Throwable)invalidRepositoryIdException);
        }
    }

    public LocalRepository getFolderLocalRepository(long folderId) throws PortalException {
        try {
            return this.getLocalRepository(this.getFolderRepositoryId(folderId));
        }
        catch (InvalidRepositoryIdException invalidRepositoryIdException) {
            throw new NoSuchFolderException(StringBundler.concat((Object[])new Object[]{"No Folder exists with the key {folderId=", folderId, "}"}), (Throwable)invalidRepositoryIdException);
        }
    }

    public com.liferay.portal.kernel.repository.Repository getFolderRepository(long folderId) throws PortalException {
        try {
            this.checkFolderPermissions(folderId);
            return this.getRepository(this.getFolderRepositoryId(folderId));
        }
        catch (InvalidRepositoryIdException invalidRepositoryIdException) {
            throw new NoSuchFolderException(StringBundler.concat((Object[])new Object[]{"No Folder exists with the key {folderId=", folderId, "}"}), (Throwable)invalidRepositoryIdException);
        }
    }

    public List<LocalRepository> getGroupLocalRepositories(long groupId) throws PortalException {
        ArrayList<LocalRepository> localRepositories = new ArrayList<LocalRepository>();
        List<Long> repositoryIds = this.getGroupRepositoryIds(groupId);
        for (long repositoryId : repositoryIds) {
            localRepositories.add(this.getLocalRepository(repositoryId));
        }
        return localRepositories;
    }

    public List<com.liferay.portal.kernel.repository.Repository> getGroupRepositories(long groupId) throws PortalException {
        ArrayList<com.liferay.portal.kernel.repository.Repository> repositories = new ArrayList<com.liferay.portal.kernel.repository.Repository>();
        List<Long> repositoryIds = this.getGroupRepositoryIds(groupId);
        for (long repositoryId : repositoryIds) {
            repositories.add(this.getRepository(repositoryId));
        }
        return repositories;
    }

    public LocalRepository getImageLocalRepository(long imageId) throws PortalException {
        return this.getLocalRepository(this.getImageRepositoryId(imageId));
    }

    public com.liferay.portal.kernel.repository.Repository getImageRepository(long imageId) throws PortalException {
        return this.getRepository(this.getImageRepositoryId(imageId));
    }

    public LocalRepository getLocalRepository(long repositoryId) throws PortalException {
        LocalRepository localRepository = this._repositoryFactory.createLocalRepository(repositoryId);
        this.checkRepository(repositoryId);
        this.checkRepositoryAccess(repositoryId);
        return localRepository;
    }

    public com.liferay.portal.kernel.repository.Repository getRepository(long repositoryId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this._repositoryFactory.createRepository(repositoryId);
        this.checkRepository(repositoryId);
        this.checkRepositoryAccess(repositoryId);
        return repository;
    }

    protected void checkFileEntryPermissions(long fileEntryId) throws PortalException {
        DLFileEntry dlFileEntry = this._dlFileEntryLocalService.fetchDLFileEntry(fileEntryId);
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (dlFileEntry != null && permissionChecker != null) {
            ModelResourcePermission dlFileEntryModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)DLFileEntry.class.getName());
            dlFileEntryModelResourcePermission.check(permissionChecker, (ClassedModel)dlFileEntry, "VIEW");
        }
    }

    protected void checkFileShortcutPermissions(long fileShortcutId) throws PortalException {
        DLFileShortcut dlFileShortcut = this._dlFileShortcutLocalService.fetchDLFileShortcut(fileShortcutId);
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (dlFileShortcut != null && permissionChecker != null) {
            ModelResourcePermission fileEntryModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)FileEntry.class.getName());
            fileEntryModelResourcePermission.check(permissionChecker, dlFileShortcut.getToFileEntryId(), "VIEW");
        }
    }

    protected void checkFileVersionPermissions(long fileVersionId) throws PortalException {
        DLFileVersion dlFileVersion = this._dlFileVersionLocalService.fetchDLFileVersion(fileVersionId);
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (dlFileVersion != null && permissionChecker != null) {
            ModelResourcePermission fileEntryModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)FileEntry.class.getName());
            fileEntryModelResourcePermission.check(permissionChecker, dlFileVersion.getFileEntryId(), "VIEW");
        }
    }

    protected void checkFolderPermissions(long folderId) throws PortalException {
        DLFolder dlFolder = this._dlFolderLocalService.fetchDLFolder(folderId);
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (dlFolder != null && permissionChecker != null) {
            ModelResourcePermission dlFolderModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)DLFolder.class.getName());
            dlFolderModelResourcePermission.check(permissionChecker, (ClassedModel)dlFolder, "VIEW");
        }
    }

    protected void checkRepository(long repositoryId) throws PortalException {
        Group group = this._groupLocalService.fetchGroup(repositoryId);
        if (group != null) {
            return;
        }
        try {
            this._repositoryLocalService.getRepository(repositoryId);
        }
        catch (NoSuchRepositoryException noSuchRepositoryException) {
            throw new InvalidRepositoryIdException(noSuchRepositoryException.getMessage());
        }
    }

    protected void checkRepositoryAccess(long repositoryId) throws PortalException {
        Group group = this._groupLocalService.fetchGroup(repositoryId);
        if (group != null) {
            return;
        }
        try {
            Repository repository = this._repositoryLocalService.fetchRepository(repositoryId);
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (repository != null && permissionChecker != null) {
                try {
                    ModelResourcePermission folderModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)Folder.class.getName());
                    ModelResourcePermissionUtil.check((ModelResourcePermission)folderModelResourcePermission, (PermissionChecker)permissionChecker, (long)repository.getGroupId(), (long)repository.getDlFolderId(), (String)"VIEW");
                }
                catch (NoSuchFolderException noSuchFolderException) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Throwable)noSuchFolderException);
                    }
                }
            }
        }
        catch (NoSuchRepositoryException noSuchRepositoryException) {
            throw new InvalidRepositoryIdException(noSuchRepositoryException.getMessage());
        }
    }

    protected long fetchFileEntryRepositoryId(long fileEntryId) {
        DLFileEntry dlFileEntry = this._dlFileEntryLocalService.fetchDLFileEntry(fileEntryId);
        if (dlFileEntry != null) {
            return dlFileEntry.getRepositoryId();
        }
        RepositoryEntry repositoryEntry = this._repositoryEntryLocalService.fetchRepositoryEntry(fileEntryId);
        if (repositoryEntry != null) {
            return repositoryEntry.getRepositoryId();
        }
        return -1L;
    }

    protected long getFileEntryRepositoryId(long fileEntryId) {
        DLFileEntry dlFileEntry = this._dlFileEntryLocalService.fetchDLFileEntry(fileEntryId);
        if (dlFileEntry != null) {
            return dlFileEntry.getRepositoryId();
        }
        RepositoryEntry repositoryEntry = this._repositoryEntryLocalService.fetchRepositoryEntry(fileEntryId);
        if (repositoryEntry != null) {
            return repositoryEntry.getRepositoryId();
        }
        throw new InvalidRepositoryIdException("No repository associated with file entry " + fileEntryId);
    }

    protected long getFileShortcutRepositoryId(long fileShortcutId) {
        DLFileShortcut dlFileShortcut = this._dlFileShortcutLocalService.fetchDLFileShortcut(fileShortcutId);
        if (dlFileShortcut != null) {
            return dlFileShortcut.getRepositoryId();
        }
        throw new InvalidRepositoryIdException("No repository associated with file shortcut " + fileShortcutId);
    }

    protected long getFileVersionRepositoryId(long fileVersionId) {
        DLFileVersion dlFileVersion = this._dlFileVersionLocalService.fetchDLFileVersion(fileVersionId);
        if (dlFileVersion != null) {
            return dlFileVersion.getRepositoryId();
        }
        RepositoryEntry repositoryEntry = this._repositoryEntryLocalService.fetchRepositoryEntry(fileVersionId);
        if (repositoryEntry != null) {
            return repositoryEntry.getRepositoryId();
        }
        throw new InvalidRepositoryIdException("No repository associated with file version " + fileVersionId);
    }

    protected long getFolderRepositoryId(long folderId) {
        DLFolder dlFolder = this._dlFolderLocalService.fetchDLFolder(folderId);
        if (dlFolder != null) {
            if (dlFolder.isMountPoint()) {
                return dlFolder.getGroupId();
            }
            return dlFolder.getRepositoryId();
        }
        RepositoryEntry repositoryEntry = this._repositoryEntryLocalService.fetchRepositoryEntry(folderId);
        if (repositoryEntry != null) {
            return repositoryEntry.getRepositoryId();
        }
        throw new InvalidRepositoryIdException("No repository associated with folder " + folderId);
    }

    protected List<Long> getGroupRepositoryIds(long groupId) {
        List repositories = this._repositoryLocalService.getGroupRepositories(groupId);
        ArrayList<Long> repositoryIds = new ArrayList<Long>(repositories.size() + 1);
        for (Repository repository : repositories) {
            repositoryIds.add(repository.getRepositoryId());
        }
        repositoryIds.add(groupId);
        return repositoryIds;
    }

    protected long getImageRepositoryId(long imageId) throws PortalException {
        DLFileEntry dlFileEntry = this._dlFileEntryService.fetchFileEntryByImageId(imageId);
        if (dlFileEntry != null) {
            return dlFileEntry.getRepositoryId();
        }
        throw new InvalidRepositoryIdException("No repository associated with image " + imageId);
    }
}

