/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scheduler.quartz.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.scheduler.JobState;
import com.liferay.portal.kernel.scheduler.JobStateSerializeUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEngine;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerState;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerResponse;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.scheduler.quartz.internal.QuartzTrigger;
import com.liferay.portal.scheduler.quartz.internal.job.MessageSenderJob;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.quartz.Calendar;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SchedulerContext;
import org.quartz.TriggerKey;
import org.quartz.TriggerUtils;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.jdbcjobstore.UpdateLockRowSemaphore;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.OperableTrigger;

@Component(enabled=false, immediate=true, service={QuartzSchedulerEngine.class, SchedulerEngine.class})
public class QuartzSchedulerEngine
implements SchedulerEngine {
    private static final Log _log = LogFactoryUtil.getLog(QuartzSchedulerEngine.class);
    @Reference
    private ClusterExecutor _clusterExecutor;
    private int _descriptionMaxLength;
    private int _groupNameMaxLength;
    private int _jobNameMaxLength;
    @Reference
    private JSONFactory _jsonFactory;
    private Scheduler _memoryScheduler;
    @Reference
    private MessageBus _messageBus;
    private Scheduler _persistedScheduler;
    private Props _props;
    private volatile boolean _schedulerEngineEnabled;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile SchedulerEngineHelper _schedulerEngineHelper;

    public void delete(String groupName, StorageType storageType) throws SchedulerException {
        try {
            Scheduler scheduler = this._getScheduler(storageType);
            groupName = this._fixMaxLength(groupName, this._groupNameMaxLength, storageType);
            Set<JobKey> jobKeys = scheduler.getJobKeys(GroupMatcher.jobGroupEquals(groupName));
            for (JobKey jobKey : jobKeys) {
                scheduler.deleteJob(jobKey);
            }
        }
        catch (Exception exception) {
            throw new SchedulerException("Unable to delete jobs in group " + groupName, (Throwable)exception);
        }
    }

    public void delete(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        try {
            Scheduler scheduler = this._getScheduler(storageType);
            jobName = this._fixMaxLength(jobName, this._jobNameMaxLength, storageType);
            groupName = this._fixMaxLength(groupName, this._groupNameMaxLength, storageType);
            JobKey jobKey = new JobKey(jobName, groupName);
            scheduler.deleteJob(jobKey);
        }
        catch (Exception exception) {
            throw new SchedulerException(StringBundler.concat((String[])new String[]{"Unable to delete job {jobName=", jobName, ", groupName=", groupName, "}"}), (Throwable)exception);
        }
    }

    public int getDescriptionMaxLength() {
        return this._descriptionMaxLength;
    }

    public int getGroupNameMaxLength() {
        return this._groupNameMaxLength;
    }

    public int getJobNameMaxLength() {
        return this._jobNameMaxLength;
    }

    public SchedulerResponse getScheduledJob(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        try {
            Scheduler scheduler = this._getScheduler(storageType);
            jobName = this._fixMaxLength(jobName, this._jobNameMaxLength, storageType);
            groupName = this._fixMaxLength(groupName, this._groupNameMaxLength, storageType);
            JobKey jobKey = new JobKey(jobName, groupName);
            return this.getScheduledJob(scheduler, jobKey);
        }
        catch (Exception exception) {
            throw new SchedulerException(StringBundler.concat((String[])new String[]{"Unable to get job {jobName=", jobName, ", groupName=", groupName, "}"}), (Throwable)exception);
        }
    }

    public List<SchedulerResponse> getScheduledJobs() throws SchedulerException {
        try {
            List<String> groupNames = this._persistedScheduler.getJobGroupNames();
            ArrayList<SchedulerResponse> schedulerResponses = new ArrayList<SchedulerResponse>();
            for (String groupName : groupNames) {
                schedulerResponses.addAll(this.getScheduledJobs(this._persistedScheduler, groupName, null));
            }
            groupNames = this._memoryScheduler.getJobGroupNames();
            for (String groupName : groupNames) {
                schedulerResponses.addAll(this.getScheduledJobs(this._memoryScheduler, groupName, null));
            }
            return schedulerResponses;
        }
        catch (Exception exception) {
            throw new SchedulerException("Unable to get jobs", (Throwable)exception);
        }
    }

    public List<SchedulerResponse> getScheduledJobs(StorageType storageType) throws SchedulerException {
        try {
            Scheduler scheduler = this._getScheduler(storageType);
            List<String> groupNames = scheduler.getJobGroupNames();
            ArrayList<SchedulerResponse> schedulerResponses = new ArrayList<SchedulerResponse>();
            for (String groupName : groupNames) {
                schedulerResponses.addAll(this.getScheduledJobs(scheduler, groupName, storageType));
            }
            return schedulerResponses;
        }
        catch (Exception exception) {
            throw new SchedulerException("Unable to get jobs with type " + storageType, (Throwable)exception);
        }
    }

    public List<SchedulerResponse> getScheduledJobs(String groupName, StorageType storageType) throws SchedulerException {
        try {
            return this.getScheduledJobs(this._getScheduler(storageType), groupName, storageType);
        }
        catch (Exception exception) {
            throw new SchedulerException("Unable to get jobs in group " + groupName, (Throwable)exception);
        }
    }

    public void pause(String groupName, StorageType storageType) throws SchedulerException {
        try {
            Scheduler scheduler = this._getScheduler(storageType);
            groupName = this._fixMaxLength(groupName, this._groupNameMaxLength, storageType);
            Set<JobKey> jobKeys = scheduler.getJobKeys(GroupMatcher.jobGroupEquals(groupName));
            scheduler.pauseJobs(GroupMatcher.jobGroupEquals(groupName));
            for (JobKey jobKey : jobKeys) {
                this._updateJobState(scheduler, jobKey, TriggerState.PAUSED, false);
            }
        }
        catch (Exception exception) {
            throw new SchedulerException("Unable to pause jobs in group " + groupName, (Throwable)exception);
        }
    }

    public void pause(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        try {
            Scheduler scheduler = this._getScheduler(storageType);
            jobName = this._fixMaxLength(jobName, this._jobNameMaxLength, storageType);
            groupName = this._fixMaxLength(groupName, this._groupNameMaxLength, storageType);
            JobKey jobKey = new JobKey(jobName, groupName);
            scheduler.pauseJob(jobKey);
            this._updateJobState(scheduler, jobKey, TriggerState.PAUSED, false);
        }
        catch (Exception exception) {
            throw new SchedulerException(StringBundler.concat((String[])new String[]{"Unable to pause job {jobName=", jobName, ", groupName=", groupName, "}"}), (Throwable)exception);
        }
    }

    public void resume(String groupName, StorageType storageType) throws SchedulerException {
        try {
            Scheduler scheduler = this._getScheduler(storageType);
            groupName = this._fixMaxLength(groupName, this._groupNameMaxLength, storageType);
            Set<JobKey> jobKeys = scheduler.getJobKeys(GroupMatcher.jobGroupEquals(groupName));
            scheduler.resumeJobs(GroupMatcher.jobGroupEquals(groupName));
            for (JobKey jobKey : jobKeys) {
                this._updateJobState(scheduler, jobKey, TriggerState.NORMAL, false);
            }
        }
        catch (Exception exception) {
            throw new SchedulerException("Unable to resume jobs in group " + groupName, (Throwable)exception);
        }
    }

    public void resume(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        try {
            Scheduler scheduler = this._getScheduler(storageType);
            jobName = this._fixMaxLength(jobName, this._jobNameMaxLength, storageType);
            groupName = this._fixMaxLength(groupName, this._groupNameMaxLength, storageType);
            JobKey jobKey = new JobKey(jobName, groupName);
            scheduler.resumeJob(jobKey);
            this._updateJobState(scheduler, jobKey, TriggerState.NORMAL, false);
        }
        catch (Exception exception) {
            throw new SchedulerException(StringBundler.concat((String[])new String[]{"Unable to resume job {jobName=", jobName, ", groupName=", groupName, "}"}), (Throwable)exception);
        }
    }

    public void schedule(Trigger trigger, String description, String destination, Message message, StorageType storageType) throws SchedulerException {
        try {
            org.quartz.Trigger quartzTrigger = (org.quartz.Trigger)trigger.getWrappedTrigger();
            if (quartzTrigger == null) {
                return;
            }
            Scheduler scheduler = this._getScheduler(storageType);
            description = this._fixMaxLength(description, this._descriptionMaxLength, storageType);
            message = message.clone();
            message.put("GROUP_NAME", (Object)trigger.getGroupName());
            message.put("JOB_NAME", (Object)trigger.getJobName());
            this.schedule(scheduler, storageType, quartzTrigger, description, destination, message);
        }
        catch (RuntimeException runtimeException) {
            if (PortalRunMode.isTestMode()) {
                int n = 0;
                StackTraceElement[] stackTraceElements = runtimeException.getStackTrace();
                StackTraceElement[] stackTraceElementArray = stackTraceElements;
                int n2 = stackTraceElementArray.length;
                if (n < n2) {
                    StackTraceElement stackTraceElement = stackTraceElementArray[n];
                    String className = stackTraceElement.getClassName();
                    if (className.contains(ServerDetector.class.getName())) {
                        if (_log.isInfoEnabled()) {
                            _log.info((Throwable)runtimeException);
                        }
                        return;
                    }
                    throw new SchedulerException("Unable to schedule job", (Throwable)runtimeException);
                }
            }
            throw new SchedulerException("Unable to schedule job", (Throwable)runtimeException);
        }
        catch (Exception exception) {
            throw new SchedulerException("Unable to schedule job", (Throwable)exception);
        }
    }

    public void shutdown() throws SchedulerException {
        try {
            if (!this._persistedScheduler.isInStandbyMode()) {
                this._persistedScheduler.standby();
            }
            if (!this._memoryScheduler.isInStandbyMode()) {
                this._memoryScheduler.standby();
            }
        }
        catch (Exception exception) {
            throw new SchedulerException("Unable to shutdown scheduler", (Throwable)exception);
        }
    }

    public void start() throws SchedulerException {
        try {
            this._persistedScheduler.start();
            this.initJobState();
            this._memoryScheduler.start();
        }
        catch (Exception exception) {
            throw new SchedulerException("Unable to start scheduler", (Throwable)exception);
        }
    }

    public void suppressError(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        try {
            Scheduler scheduler = this._getScheduler(storageType);
            jobName = this._fixMaxLength(jobName, this._jobNameMaxLength, storageType);
            groupName = this._fixMaxLength(groupName, this._groupNameMaxLength, storageType);
            JobKey jobKey = new JobKey(jobName, groupName);
            this._updateJobState(scheduler, jobKey, null, true);
        }
        catch (Exception exception) {
            throw new SchedulerException(StringBundler.concat((String[])new String[]{"Unable to suppress error for job {jobName=", jobName, ", groupName=", groupName, "}"}), (Throwable)exception);
        }
    }

    public void unschedule(String groupName, StorageType storageType) throws SchedulerException {
        try {
            Scheduler scheduler = this._getScheduler(storageType);
            groupName = this._fixMaxLength(groupName, this._groupNameMaxLength, storageType);
            Set<JobKey> jobKeys = scheduler.getJobKeys(GroupMatcher.jobGroupEquals(groupName));
            for (JobKey jobKey : jobKeys) {
                this.unschedule(scheduler, jobKey);
            }
        }
        catch (Exception exception) {
            throw new SchedulerException("Unable to unschedule jobs in group " + groupName, (Throwable)exception);
        }
    }

    public void unschedule(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        try {
            Scheduler scheduler = this._getScheduler(storageType);
            jobName = this._fixMaxLength(jobName, this._jobNameMaxLength, storageType);
            groupName = this._fixMaxLength(groupName, this._groupNameMaxLength, storageType);
            JobKey jobKey = new JobKey(jobName, groupName);
            this.unschedule(scheduler, jobKey);
        }
        catch (Exception exception) {
            throw new SchedulerException(StringBundler.concat((String[])new String[]{"Unable to unschedule job {jobName=", jobName, ", groupName=", groupName, "}"}), (Throwable)exception);
        }
    }

    public void update(Trigger trigger, StorageType storageType) throws SchedulerException {
        try {
            this.update(this._getScheduler(storageType), trigger, storageType);
        }
        catch (Exception exception) {
            throw new SchedulerException("Unable to update trigger", (Throwable)exception);
        }
    }

    public void validateTrigger(Trigger trigger, StorageType storageType) throws SchedulerException {
        org.quartz.Trigger quartzTrigger = (org.quartz.Trigger)trigger.getWrappedTrigger();
        if (quartzTrigger == null) {
            return;
        }
        Scheduler scheduler = this._getScheduler(storageType);
        Calendar calendar = null;
        try {
            calendar = scheduler.getCalendar(quartzTrigger.getCalendarName());
        }
        catch (org.quartz.SchedulerException schedulerException) {
            throw new SchedulerException("Unable to validate trigger \"" + quartzTrigger.getKey() + "\"", (Throwable)schedulerException);
        }
        List<Date> dates = TriggerUtils.computeFireTimes((OperableTrigger)quartzTrigger, calendar, 1);
        if (!dates.isEmpty()) {
            return;
        }
        throw new SchedulerException("Based on configured schedule, the given trigger \"" + quartzTrigger.getKey() + "\" will never fire.");
    }

    @Activate
    protected void activate() {
        this._schedulerEngineEnabled = GetterUtil.getBoolean((String)this._props.get("scheduler.enabled"));
        if (!this._schedulerEngineEnabled) {
            return;
        }
        try {
            this._persistedScheduler = this._initializeScheduler("persisted.scheduler.", true);
            this._memoryScheduler = this._initializeScheduler("memory.scheduler.", false);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to initialize engine", (Throwable)exception);
        }
    }

    @Deactivate
    protected void deactivate() {
        block5: {
            if (!this._schedulerEngineEnabled) {
                return;
            }
            try {
                if (!this._persistedScheduler.isShutdown()) {
                    this._persistedScheduler.shutdown(false);
                }
                if (!this._memoryScheduler.isShutdown()) {
                    this._memoryScheduler.shutdown(false);
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)"Unable to deactivate scheduler", (Throwable)exception);
            }
        }
    }

    protected Message getMessage(JobDataMap jobDataMap) {
        String messageJSON = (String)jobDataMap.get("MESSAGE");
        return (Message)this._jsonFactory.deserialize(messageJSON);
    }

    protected SchedulerResponse getScheduledJob(Scheduler scheduler, JobKey jobKey) throws Exception {
        JobDetail jobDetail = scheduler.getJobDetail(jobKey);
        if (jobDetail == null) {
            return null;
        }
        SchedulerResponse schedulerResponse = new SchedulerResponse();
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        schedulerResponse.setDescription(jobDataMap.getString("DESCRIPTION"));
        schedulerResponse.setDestinationName(jobDataMap.getString("DESTINATION_NAME"));
        Message message = this.getMessage(jobDataMap);
        message.put("JOB_STATE", (Object)this._getJobState(jobDataMap));
        schedulerResponse.setMessage(message);
        schedulerResponse.setStorageType(StorageType.valueOf((String)jobDataMap.getString("STORAGE_TYPE")));
        String jobName = jobKey.getName();
        String groupName = jobKey.getGroup();
        TriggerKey triggerKey = new TriggerKey(jobName, groupName);
        org.quartz.Trigger trigger = scheduler.getTrigger(triggerKey);
        if (trigger == null) {
            schedulerResponse.setGroupName(groupName);
            schedulerResponse.setJobName(jobName);
            return schedulerResponse;
        }
        message.put("END_TIME", (Object)trigger.getEndTime());
        message.put("FINAL_FIRE_TIME", (Object)trigger.getFinalFireTime());
        message.put("NEXT_FIRE_TIME", (Object)trigger.getNextFireTime());
        message.put("PREVIOUS_FIRE_TIME", (Object)trigger.getPreviousFireTime());
        message.put("START_TIME", (Object)trigger.getStartTime());
        schedulerResponse.setTrigger((Trigger)new QuartzTrigger(trigger));
        return schedulerResponse;
    }

    protected List<SchedulerResponse> getScheduledJobs(Scheduler scheduler, String groupName, StorageType storageType) throws Exception {
        groupName = this._fixMaxLength(groupName, this._groupNameMaxLength, storageType);
        ArrayList<SchedulerResponse> schedulerResponses = new ArrayList<SchedulerResponse>();
        Set<JobKey> jobKeys = scheduler.getJobKeys(GroupMatcher.jobGroupEquals(groupName));
        for (JobKey jobKey : jobKeys) {
            SchedulerResponse schedulerResponse = this.getScheduledJob(scheduler, jobKey);
            if (schedulerResponse == null || storageType != null && storageType != schedulerResponse.getStorageType()) continue;
            schedulerResponses.add(schedulerResponse);
        }
        return schedulerResponses;
    }

    protected void initJobState() throws Exception {
        List<String> groupNames = this._persistedScheduler.getJobGroupNames();
        for (String groupName : groupNames) {
            Set<JobKey> jobKeys = this._persistedScheduler.getJobKeys(GroupMatcher.jobGroupEquals(groupName));
            for (JobKey jobKey : jobKeys) {
                org.quartz.Trigger trigger = this._persistedScheduler.getTrigger(new TriggerKey(jobKey.getName(), jobKey.getGroup()));
                if (trigger != null) continue;
                if (this._schedulerEngineHelper != null) {
                    JobDetail jobDetail = this._persistedScheduler.getJobDetail(jobKey);
                    this._schedulerEngineHelper.auditSchedulerJobs(this.getMessage(jobDetail.getJobDataMap()), TriggerState.EXPIRED);
                }
                this._persistedScheduler.deleteJob(jobKey);
            }
        }
    }

    protected void schedule(Scheduler scheduler, StorageType storageType, org.quartz.Trigger trigger, String description, String destinationName, Message message) throws Exception {
        block5: {
            try {
                JobBuilder jobBuilder = JobBuilder.newJob(MessageSenderJob.class);
                jobBuilder.withIdentity(trigger.getJobKey());
                jobBuilder.storeDurably();
                JobDetail jobDetail = jobBuilder.build();
                JobDataMap jobDataMap = jobDetail.getJobDataMap();
                jobDataMap.put("DESCRIPTION", description);
                jobDataMap.put("DESTINATION_NAME", destinationName);
                jobDataMap.put("MESSAGE", this._jsonFactory.serialize((Object)message));
                jobDataMap.put("STORAGE_TYPE", storageType.toString());
                JobState jobState = new JobState(TriggerState.NORMAL, message.getInteger("EXCEPTIONS_MAX_SIZE"));
                jobDataMap.put("JOB_STATE", (Object)JobStateSerializeUtil.serialize((JobState)jobState));
                try {
                    scheduler.scheduleJob(jobDetail, trigger);
                }
                catch (JobPersistenceException jobPersistenceException) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Scheduler job " + trigger.getJobKey() + " already exists"), (Throwable)jobPersistenceException);
                    }
                }
            }
            catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
                if (!_log.isInfoEnabled()) break block5;
                _log.info((Object)"Message is already scheduled", (Throwable)objectAlreadyExistsException);
            }
        }
    }

    @Reference(unbind="-")
    protected void setProps(Props props) {
        this._props = props;
        this._descriptionMaxLength = GetterUtil.getInteger((String)this._props.get("scheduler.description.max.length"), (int)120);
        this._groupNameMaxLength = GetterUtil.getInteger((String)this._props.get("scheduler.group.name.max.length"), (int)80);
        this._jobNameMaxLength = GetterUtil.getInteger((String)this._props.get("scheduler.job.name.max.length"), (int)80);
    }

    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.portal.scheduler.quartz)(release.schema.version=1.0.0))", unbind="-")
    protected void setRelease(Release release) {
    }

    protected void unschedule(Scheduler scheduler, JobKey jobKey) throws Exception {
        JobDetail jobDetail = scheduler.getJobDetail(jobKey);
        if (jobDetail == null) {
            return;
        }
        TriggerKey triggerKey = new TriggerKey(jobKey.getName(), jobKey.getGroup());
        org.quartz.Trigger trigger = scheduler.getTrigger(triggerKey);
        if (trigger == null) {
            return;
        }
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        JobState jobState = this._getJobState(jobDataMap);
        jobState.setTriggerDate("END_TIME", new Date());
        jobState.setTriggerDate("FINAL_FIRE_TIME", trigger.getPreviousFireTime());
        jobState.setTriggerDate("NEXT_FIRE_TIME", null);
        jobState.setTriggerDate("PREVIOUS_FIRE_TIME", trigger.getPreviousFireTime());
        jobState.setTriggerDate("START_TIME", trigger.getStartTime());
        jobState.setTriggerState(TriggerState.UNSCHEDULED);
        jobState.clearExceptions();
        jobDataMap.put("JOB_STATE", (Object)JobStateSerializeUtil.serialize((JobState)jobState));
        scheduler.unscheduleJob(triggerKey);
        scheduler.addJob(jobDetail, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(Scheduler scheduler, Trigger trigger, StorageType storageType) throws Exception {
        org.quartz.Trigger quartzTrigger = (org.quartz.Trigger)trigger.getWrappedTrigger();
        if (quartzTrigger == null) {
            return;
        }
        TriggerKey triggerKey = quartzTrigger.getKey();
        if (scheduler.getTrigger(triggerKey) != null) {
            scheduler.rescheduleJob(triggerKey, quartzTrigger);
        } else {
            JobKey jobKey = quartzTrigger.getJobKey();
            JobDetail jobDetail = scheduler.getJobDetail(jobKey);
            if (jobDetail == null) {
                return;
            }
            QuartzSchedulerEngine quartzSchedulerEngine = this;
            synchronized (quartzSchedulerEngine) {
                scheduler.deleteJob(jobKey);
                scheduler.scheduleJob(jobDetail, quartzTrigger);
            }
            this._updateJobState(scheduler, jobKey, TriggerState.NORMAL, true);
        }
    }

    private String _fixMaxLength(String argument, int maxLength, StorageType storageType) {
        if (argument == null || storageType != StorageType.PERSISTED) {
            return argument;
        }
        if (argument.length() > maxLength) {
            argument = argument.substring(0, maxLength);
        }
        return argument;
    }

    private JobState _getJobState(JobDataMap jobDataMap) {
        Map jobStateMap = (Map)jobDataMap.get("JOB_STATE");
        return JobStateSerializeUtil.deserialize((Map)jobStateMap);
    }

    private Scheduler _getScheduler(StorageType storageType) {
        if (storageType == StorageType.PERSISTED) {
            return this._persistedScheduler;
        }
        return this._memoryScheduler;
    }

    private Scheduler _initializeScheduler(String propertiesPrefix, boolean useQuartzCluster) throws Exception {
        StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
        Properties properties = this._props.getProperties(propertiesPrefix, true);
        if (useQuartzCluster) {
            String lockHandlerClassName;
            DB db = DBManagerUtil.getDB();
            DBType dbType = db.getDBType();
            if (dbType == DBType.SQLSERVER && Validator.isNull((String)(lockHandlerClassName = properties.getProperty("org.quartz.jobStore.lockHandler.class")))) {
                properties.setProperty("org.quartz.jobStore.lockHandler.class", UpdateLockRowSemaphore.class.getName());
            }
            if (GetterUtil.getBoolean((String)this._props.get("cluster.link.enabled"))) {
                if (dbType == DBType.HYPERSONIC) {
                    _log.error((Object)"Unable to cluster scheduler on Hypersonic");
                } else {
                    properties.put("org.quartz.jobStore.isClustered", Boolean.TRUE.toString());
                }
            }
        }
        schedulerFactory.initialize(properties);
        Scheduler scheduler = schedulerFactory.getScheduler();
        SchedulerContext schedulerContext = scheduler.getContext();
        schedulerContext.put("clusterExecutor", (Object)this._clusterExecutor);
        schedulerContext.put("jSONFactory", (Object)this._jsonFactory);
        schedulerContext.put("messageBus", (Object)this._messageBus);
        schedulerContext.put("props", (Object)this._props);
        return scheduler;
    }

    private void _updateJobState(Scheduler scheduler, JobKey jobKey, TriggerState triggerState, boolean suppressError) throws Exception {
        JobDetail jobDetail = scheduler.getJobDetail(jobKey);
        if (jobDetail == null) {
            return;
        }
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        JobState jobState = this._getJobState(jobDataMap);
        if (triggerState != null) {
            jobState.setTriggerState(triggerState);
        }
        if (suppressError) {
            jobState.clearExceptions();
        }
        jobDataMap.put("JOB_STATE", (Object)JobStateSerializeUtil.serialize((JobState)jobState));
        scheduler.addJob(jobDetail, true);
    }
}

