/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scheduler.quartz.internal.job;

import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.scheduler.JobState;
import com.liferay.portal.kernel.scheduler.JobStateSerializeUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.Props;
import java.io.Serializable;
import java.util.Map;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.Scheduler;

public class MessageSenderJob
implements Job {
    private static final Log _log = LogFactoryUtil.getLog(MessageSenderJob.class);
    private static final MethodKey _deleteJobMethodKey = new MethodKey(SchedulerEngineHelperUtil.class, "delete", new Class[]{String.class, String.class, StorageType.class});
    private ClusterExecutor _clusterExecutor;
    private JSONFactory _jsonFactory;
    private MessageBus _messageBus;
    private Props _props;

    @Override
    public void execute(JobExecutionContext jobExecutionContext) {
        try {
            this._execute(jobExecutionContext);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to execute job", (Throwable)exception);
        }
    }

    public void setClusterExecutor(ClusterExecutor clusterExecutor) {
        this._clusterExecutor = clusterExecutor;
    }

    public void setJSONFactory(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    public void setMessageBus(MessageBus messageBus) {
        this._messageBus = messageBus;
    }

    public void setProps(Props props) {
        this._props = props;
    }

    private void _execute(JobExecutionContext jobExecutionContext) throws Exception {
        JobDetail jobDetail = jobExecutionContext.getJobDetail();
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        String destinationName = jobDataMap.getString("DESTINATION_NAME");
        String messageJSON = (String)jobDataMap.get("MESSAGE");
        if (messageJSON == null) {
            throw new NullPointerException("Message retrieved from job data map is null");
        }
        Message message = (Message)this._jsonFactory.deserialize(messageJSON);
        message.put("DESTINATION_NAME", (Object)destinationName);
        Map jobStateMap = (Map)jobDataMap.get("JOB_STATE");
        JobState jobState = JobStateSerializeUtil.deserialize((Map)jobStateMap);
        StorageType storageType = StorageType.valueOf((String)jobDataMap.getString("STORAGE_TYPE"));
        if (jobExecutionContext.getNextFireTime() == null) {
            message.put("DISABLE", (Object)true);
            JobKey jobKey = jobDetail.getKey();
            if (GetterUtil.getBoolean((String)this._props.get("cluster.link.enabled")) && storageType == StorageType.MEMORY_CLUSTERED) {
                this._notifyClusterMember(jobKey, storageType);
            }
            if (storageType == StorageType.PERSISTED) {
                Scheduler scheduler = jobExecutionContext.getScheduler();
                scheduler.deleteJob(jobKey);
            }
        }
        message.put("JOB_STATE", (Object)jobState);
        message.put("STORAGE_TYPE", (Object)storageType);
        this._messageBus.sendMessage(destinationName, message);
    }

    private void _notifyClusterMember(JobKey jobKey, StorageType storageType) throws Exception {
        MethodHandler methodHandler = new MethodHandler(_deleteJobMethodKey, new Object[]{jobKey.getName(), jobKey.getGroup(), storageType});
        ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((Serializable)methodHandler, (boolean)true);
        this._clusterExecutor.execute(clusterRequest);
    }
}

