/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scheduler.quartz.internal.portal.profile;

import com.liferay.portal.kernel.scheduler.SchedulerEngine;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.ProxyFactory;
import com.liferay.portal.profile.BaseDSModulePortalProfile;
import com.liferay.portal.profile.PortalProfile;
import com.liferay.portal.scheduler.quartz.internal.QuartzSchedulerEngine;
import com.liferay.portal.scheduler.quartz.internal.QuartzSchemaManager;
import com.liferay.portal.scheduler.quartz.internal.QuartzTriggerFactory;
import com.liferay.portal.scheduler.quartz.internal.messaging.proxy.QuartzSchedulerProxyMessageListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PortalProfile.class})
public class ModulePortalProfile
extends BaseDSModulePortalProfile {
    private Props _props;
    private ServiceRegistration<SchedulerEngine> _schedulerEngineServiceRegistration;
    private ServiceRegistration<TriggerFactory> _triggerFactoryServiceRegistration;

    @Activate
    protected void activate(ComponentContext componentContext) {
        List supportedPortalProfileNames = null;
        if (GetterUtil.getBoolean((String)this._props.get("scheduler.enabled"))) {
            supportedPortalProfileNames = new ArrayList();
            supportedPortalProfileNames.add("CE");
            supportedPortalProfileNames.add("DXP");
        } else {
            supportedPortalProfileNames = Collections.emptyList();
            BundleContext bundleContext = componentContext.getBundleContext();
            this._schedulerEngineServiceRegistration = bundleContext.registerService(SchedulerEngine.class, ProxyFactory.newDummyInstance(SchedulerEngine.class), (Dictionary)new HashMapDictionary());
            this._triggerFactoryServiceRegistration = bundleContext.registerService(TriggerFactory.class, ProxyFactory.newDummyInstance(TriggerFactory.class), (Dictionary)new HashMapDictionary());
        }
        this.init(componentContext, supportedPortalProfileNames, new String[]{QuartzSchedulerEngine.class.getName(), QuartzSchedulerProxyMessageListener.class.getName(), QuartzSchemaManager.class.getName(), QuartzTriggerFactory.class.getName()});
    }

    @Deactivate
    protected void deactivate() {
        if (this._triggerFactoryServiceRegistration != null) {
            this._triggerFactoryServiceRegistration.unregister();
        }
        if (this._schedulerEngineServiceRegistration != null) {
            this._schedulerEngineServiceRegistration.unregister();
        }
    }

    @Reference(unbind="-")
    protected void setProps(Props props) {
        this._props = props;
    }
}

