/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scheduler.quartz.internal;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={QuartzSchemaManager.class})
public class QuartzSchemaManager {
    private static final Log _log = LogFactoryUtil.getLog(QuartzSchemaManager.class);
    @Reference(target="(&(bean.id=liferayDataSource)(original.bean=true))")
    private DataSource _dataSource;

    @Activate
    protected void activate() {
        Throwable throwable;
        Connection connection;
        block61: {
            try {
                connection = this._dataSource.getConnection();
                throwable = null;
                try (PreparedStatement preparedStatement = connection.prepareStatement("select count(*) from QUARTZ_JOB_DETAILS");
                     ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        return;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (connection != null) {
                        if (throwable != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            connection.close();
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (!_log.isInfoEnabled()) break block61;
                _log.info((Object)exception, (Throwable)exception);
            }
        }
        try {
            connection = this._dataSource.getConnection();
            throwable = null;
            try {
                this._populateSchema(connection);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (connection != null) {
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private void _populateSchema(Connection connection) throws Exception {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("/META-INF/sql/quartz-tables.sql");
        if (inputStream == null) {
            throw new SystemException("Unable to read /META-INF/sql/quartz-tables.sql");
        }
        String template = StringUtil.read((InputStream)inputStream);
        DB db = DBManagerUtil.getDB();
        boolean autoCommit = connection.getAutoCommit();
        try {
            connection.setAutoCommit(false);
            db.runSQLTemplateString(connection, template, false);
            connection.commit();
        }
        catch (Exception exception) {
            connection.rollback();
            throw exception;
        }
        finally {
            connection.setAutoCommit(autoCommit);
        }
    }
}

