/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scheduler.quartz.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.scheduler.quartz.internal.QuartzTrigger;
import java.util.Date;
import java.util.TimeZone;
import org.osgi.service.component.annotations.Component;
import org.quartz.CalendarIntervalScheduleBuilder;
import org.quartz.CronScheduleBuilder;
import org.quartz.DateBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

@Component(enabled=false, immediate=true, service={QuartzTriggerFactory.class, TriggerFactory.class})
public class QuartzTriggerFactory
implements TriggerFactory {
    private static final Log _log = LogFactoryUtil.getLog(QuartzTriggerFactory.class);

    public com.liferay.portal.kernel.scheduler.Trigger createTrigger(String jobName, String groupName, Date startDate, Date endDate, int interval, TimeUnit timeUnit) {
        if (interval < 0) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Not scheduling ", jobName, " because interval is less than 0"}));
            }
            return null;
        }
        if (interval <= 0) {
            return this.createTrigger(jobName, groupName, startDate, endDate, (ScheduleBuilder)null);
        }
        if (timeUnit == TimeUnit.MILLISECOND) {
            SimpleScheduleBuilder simpleScheduleBuilder = SimpleScheduleBuilder.simpleSchedule();
            simpleScheduleBuilder.withIntervalInMilliseconds(interval);
            simpleScheduleBuilder.withRepeatCount(-1);
            return this.createTrigger(jobName, groupName, startDate, endDate, simpleScheduleBuilder);
        }
        CalendarIntervalScheduleBuilder calendarIntervalScheduleBuilder = CalendarIntervalScheduleBuilder.calendarIntervalSchedule();
        calendarIntervalScheduleBuilder.withInterval(interval, DateBuilder.IntervalUnit.valueOf(timeUnit.name()));
        return this.createTrigger(jobName, groupName, startDate, endDate, calendarIntervalScheduleBuilder);
    }

    public com.liferay.portal.kernel.scheduler.Trigger createTrigger(String jobName, String groupName, Date startDate, Date endDate, String cronExpression) {
        return this.createTrigger(jobName, groupName, startDate, endDate, CronScheduleBuilder.cronSchedule(cronExpression));
    }

    public com.liferay.portal.kernel.scheduler.Trigger createTrigger(String jobName, String groupName, Date startDate, Date endDate, String cronExpression, TimeZone timeZone) {
        CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule(cronExpression);
        return this.createTrigger(jobName, groupName, startDate, endDate, cronScheduleBuilder.inTimeZone(timeZone));
    }

    public com.liferay.portal.kernel.scheduler.Trigger createTrigger(com.liferay.portal.kernel.scheduler.Trigger trigger, Date startDate, Date endDate) {
        Trigger wrappedTrigger = (Trigger)trigger.getWrappedTrigger();
        return this.createTrigger(trigger.getJobName(), trigger.getGroupName(), startDate, endDate, wrappedTrigger.getScheduleBuilder());
    }

    protected com.liferay.portal.kernel.scheduler.Trigger createTrigger(String jobName, String groupName, Date startDate, Date endDate, ScheduleBuilder<?> scheduleBuilder) {
        if (startDate == null) {
            startDate = new Date(System.currentTimeMillis());
        }
        TriggerBuilder<Trigger> triggerBuilder = TriggerBuilder.newTrigger();
        triggerBuilder.endAt(endDate);
        triggerBuilder.forJob(jobName, groupName);
        triggerBuilder.startAt(startDate);
        triggerBuilder.withIdentity(jobName, groupName);
        if (scheduleBuilder != null) {
            triggerBuilder.withSchedule(scheduleBuilder);
        }
        return new QuartzTrigger(triggerBuilder.build());
    }
}

