/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scripting.executor.internal.messaging;

import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.scripting.Scripting;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.scripting.executor.internal.messaging.ScriptingExecutorMessageListener;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={})
public class ScriptingExecutorMessagingConfigurator {
    @Reference
    private DestinationFactory _destinationFactory;
    @Reference
    private MessageBus _messageBus;
    @Reference
    private Scripting _scripting;
    private ServiceRegistration<Destination> _serviceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext) {
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration("parallel", "liferay/scripting_executor");
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        HashMapDictionary properties = HashMapDictionaryBuilder.put((Object)"destination.name", (Object)destination.getName()).build();
        this._serviceRegistration = bundleContext.registerService(Destination.class, (Object)destination, (Dictionary)properties);
        ScriptingExecutorMessageListener scriptingExecutorMessageListener = new ScriptingExecutorMessageListener(this._scripting);
        destination.register((MessageListener)scriptingExecutorMessageListener);
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }
}

