/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scripting.groovy.internal;

import com.liferay.portal.kernel.scripting.ScriptingException;
import com.liferay.portal.kernel.scripting.ScriptingValidator;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import groovy.lang.GroovyShell;
import org.osgi.service.component.annotations.Component;

@Component(property={"scripting.language=groovy"}, service={ScriptingValidator.class})
public class GroovyScriptingValidator
implements ScriptingValidator {
    public static final String LANGUAGE = "groovy";

    public String getLanguage() {
        return LANGUAGE;
    }

    public void validate(String script) throws ScriptingException {
        try {
            GroovyShell groovyShell = new GroovyShell(this.getClassLoader());
            groovyShell.parse(script);
        }
        catch (Exception exception) {
            throw new ScriptingException((Throwable)exception);
        }
    }

    protected ClassLoader getClassLoader() {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        Thread currentThread = Thread.currentThread();
        return AggregateClassLoader.getAggregateClassLoader((ClassLoader)classLoader, (ClassLoader[])new ClassLoader[]{currentThread.getContextClassLoader()});
    }
}

