Liferay.Loader.define('portal-search-admin-web$dnd-core@11.1.3/dist/esm/actions/dragDrop/hover', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import { invariant } from '@react-dnd/invariant';
    import { matchesType } from '../../utils/matchesType';
    import { HOVER } from './types';
    export function createHover(manager) {
      return function hover(targetIdsArg) {
        var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
            clientOffset = _ref.clientOffset;

        verifyTargetIdsIsArray(targetIdsArg);
        var targetIds = targetIdsArg.slice(0);
        var monitor = manager.getMonitor();
        var registry = manager.getRegistry();
        checkInvariants(targetIds, monitor, registry);
        var draggedItemType = monitor.getItemType();
        removeNonMatchingTargetIds(targetIds, registry, draggedItemType);
        hoverAllTargets(targetIds, monitor, registry);
        return {
          type: HOVER,
          payload: {
            targetIds: targetIds,
            clientOffset: clientOffset || null
          }
        };
      };
    }

    function verifyTargetIdsIsArray(targetIdsArg) {
      invariant(Array.isArray(targetIdsArg), 'Expected targetIds to be an array.');
    }

    function checkInvariants(targetIds, monitor, registry) {
      invariant(monitor.isDragging(), 'Cannot call hover while not dragging.');
      invariant(!monitor.didDrop(), 'Cannot call hover after drop.');

      for (var i = 0; i < targetIds.length; i++) {
        var targetId = targetIds[i];
        invariant(targetIds.lastIndexOf(targetId) === i, 'Expected targetIds to be unique in the passed array.');
        var target = registry.getTarget(targetId);
        invariant(target, 'Expected targetIds to be registered.');
      }
    }

    function removeNonMatchingTargetIds(targetIds, registry, draggedItemType) {
      // Remove those targetIds that don't match the targetType.  This
      // fixes shallow isOver which would only be non-shallow because of
      // non-matching targets.
      for (var i = targetIds.length - 1; i >= 0; i--) {
        var targetId = targetIds[i];
        var targetType = registry.getTargetType(targetId);

        if (!matchesType(targetType, draggedItemType)) {
          targetIds.splice(i, 1);
        }
      }
    }

    function hoverAllTargets(targetIds, monitor, registry) {
      // Finally call hover on all matching targets.
      targetIds.forEach(function (targetId) {
        var target = registry.getTarget(targetId);
        target.hover(monitor, targetId);
      });
    }
  }
});
//# sourceMappingURL=hover.js.map