/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.bucket;

import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.bucket.Bucket;
import com.liferay.portal.search.aggregation.bucket.GeoHashGridAggregation;
import com.liferay.portal.search.aggregation.bucket.GeoHashGridAggregationResult;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseGeoHashGridAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testGeoHashGrid() throws Exception {
        this.addDocument(DocumentCreationHelpers.singleGeoLocation("geoLocation", 52.374081, 4.91235));
        this.addDocument(DocumentCreationHelpers.singleGeoLocation("geoLocation", 52.369219, 4.901618));
        this.addDocument(DocumentCreationHelpers.singleGeoLocation("geoLocation", 52.369219, 4.901618));
        this.addDocument(DocumentCreationHelpers.singleGeoLocation("geoLocation", 51.2229, 4.4052));
        this.addDocument(DocumentCreationHelpers.singleGeoLocation("geoLocation", 48.861111, 2.336389));
        this.addDocument(DocumentCreationHelpers.singleGeoLocation("geoLocation", 48.86, 2.327));
        GeoHashGridAggregation geoHashGridAggregation = this.aggregations.geoHashGrid("geoHash", "geoLocation");
        geoHashGridAggregation.setPrecision(Integer.valueOf(3));
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation((Aggregation)geoHashGridAggregation));
            indexingTestHelper.search();
            GeoHashGridAggregationResult geoBoundsAggregationResult = (GeoHashGridAggregationResult)indexingTestHelper.getAggregationResult((Aggregation)geoHashGridAggregation);
            ArrayList buckets = new ArrayList(geoBoundsAggregationResult.getBuckets());
            Assert.assertEquals((String)"Num buckets", (long)3L, (long)buckets.size());
            this.assertBucket((Bucket)buckets.get(0), "u17", 3L);
            this.assertBucket((Bucket)buckets.get(1), "u09", 2L);
            this.assertBucket((Bucket)buckets.get(2), "u15", 1L);
        });
    }

    protected void assertBucket(Bucket bucket, String expectedKey, long expectedCount) {
        Assert.assertEquals((Object)expectedKey, (Object)bucket.getKey());
        Assert.assertEquals((long)expectedCount, (long)bucket.getDocCount());
    }
}

