/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.pipeline;

import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.pipeline.PercentilesBucketPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.PercentilesBucketPipelineAggregationResult;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregation;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public abstract class BasePercentilesPipelineAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testPercentiles() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        PercentilesBucketPipelineAggregation percentilesBucketPipelineAggregation = this.getAggregation();
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> {
                searchRequestBuilder.addAggregation((Aggregation)this.aggregationFixture.getDefaultHistogramAggregation());
                searchRequestBuilder.addPipelineAggregation((PipelineAggregation)percentilesBucketPipelineAggregation);
            });
            indexingTestHelper.search();
            PercentilesBucketPipelineAggregationResult percentilesBucketPipelineAggregationResult = (PercentilesBucketPipelineAggregationResult)indexingTestHelper.getAggregationResult((PipelineAggregation)percentilesBucketPipelineAggregation);
            Map percentiles = percentilesBucketPipelineAggregationResult.getPercentiles();
            Assert.assertEquals((String)"Total number of buckets", (float)7.0f, (float)percentiles.size(), (float)0.0f);
            Assert.assertEquals((String)"1%", (double)10.0, (double)((Double)percentiles.get(1.0)), (double)0.0);
            Assert.assertEquals((String)"5%", (double)10.0, (double)((Double)percentiles.get(5.0)), (double)0.0);
            Assert.assertEquals((String)"25.%", (double)20.0, (double)((Double)percentiles.get(25.0)), (double)0.0);
            Assert.assertEquals((String)"50%", (double)35.0, (double)((Double)percentiles.get(50.0)), (double)0.0);
            Assert.assertEquals((String)"75%", (double)60.0, (double)((Double)percentiles.get(75.0)), (double)0.0);
            Assert.assertEquals((String)"95%", (double)85.0, (double)((Double)percentiles.get(95.0)), (double)0.0);
            Assert.assertEquals((String)"99%", (double)85.0, (double)((Double)percentiles.get(99.0)), (double)0.0);
        });
    }

    @Test
    public void testPercentilesWithSpecifiedPercents() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        PercentilesBucketPipelineAggregation percentilesBucketPipelineAggregation = this.getAggregation();
        percentilesBucketPipelineAggregation.setPercents(new double[]{25.0, 50.0, 75.0});
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> {
                searchRequestBuilder.addAggregation((Aggregation)this.aggregationFixture.getDefaultHistogramAggregation());
                searchRequestBuilder.addPipelineAggregation((PipelineAggregation)percentilesBucketPipelineAggregation);
            });
            indexingTestHelper.search();
            PercentilesBucketPipelineAggregationResult percentilesBucketPipelineAggregationResult = (PercentilesBucketPipelineAggregationResult)indexingTestHelper.getAggregationResult((PipelineAggregation)percentilesBucketPipelineAggregation);
            Map percentiles = percentilesBucketPipelineAggregationResult.getPercentiles();
            Assert.assertEquals((String)"Total number of buckets", (float)3.0f, (float)percentiles.size(), (float)0.0f);
            Assert.assertEquals((String)"25%", (double)20.0, (double)((Double)percentiles.get(25.0)), (double)0.0);
            Assert.assertEquals((String)"50%", (double)35.0, (double)((Double)percentiles.get(50.0)), (double)0.0);
            Assert.assertEquals((String)"75%", (double)60.0, (double)((Double)percentiles.get(75.0)), (double)0.0);
        });
    }

    protected PercentilesBucketPipelineAggregation getAggregation() {
        return this.aggregations.percentilesBucket("percentiles", "histogram>sum");
    }
}

