/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.pipeline;

import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.bucket.Bucket;
import com.liferay.portal.search.aggregation.bucket.HistogramAggregation;
import com.liferay.portal.search.aggregation.bucket.HistogramAggregationResult;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.SerialDiffPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.SerialDiffPipelineAggregationResult;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.ArrayList;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseSerialDiffPipelineAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testSerialDiff() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", i));
        }
        HistogramAggregation histogramAggregation = this.aggregationFixture.getDefaultHistogramAggregation();
        SerialDiffPipelineAggregation serialDiffPipelineAggregation = this.aggregations.serialDiff("serial_diff", "sum");
        serialDiffPipelineAggregation.setLag(Integer.valueOf(2));
        histogramAggregation.addPipelineAggregation((PipelineAggregation)serialDiffPipelineAggregation);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation((Aggregation)histogramAggregation));
            indexingTestHelper.search();
            HistogramAggregationResult histogramAggregationResult = (HistogramAggregationResult)indexingTestHelper.getAggregationResult((Aggregation)histogramAggregation);
            ArrayList buckets = new ArrayList(histogramAggregationResult.getBuckets());
            Assert.assertEquals((String)"Number of buckets", (long)5L, (long)buckets.size());
            this.assertBucket((Bucket)buckets.get(0), "0.0", 4L, null);
            this.assertBucket((Bucket)buckets.get(1), "5.0", 5L, null);
            this.assertBucket((Bucket)buckets.get(2), "10.0", 5L, 50.0);
            this.assertBucket((Bucket)buckets.get(3), "15.0", 5L, 50.0);
            this.assertBucket((Bucket)buckets.get(4), "20.0", 1L, -40.0);
        });
    }

    protected void assertBucket(Bucket bucket, String expectedKey, long expectedCount, Double serialDiffValue) {
        Assert.assertEquals((Object)expectedKey, (Object)bucket.getKey());
        Assert.assertEquals((long)expectedCount, (long)bucket.getDocCount());
        if (serialDiffValue != null) {
            Map childrenAggregationResults = bucket.getChildrenAggregationResults();
            SerialDiffPipelineAggregationResult serialDiffPipelineAggregationResult = (SerialDiffPipelineAggregationResult)childrenAggregationResults.get("serial_diff");
            Assert.assertNotNull((Object)serialDiffPipelineAggregationResult);
            Assert.assertEquals((String)"Serial diff value", (double)serialDiffValue, (double)serialDiffPipelineAggregationResult.getValue(), (double)0.0);
        }
    }
}

