/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.facet;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.ModifiedFacet;
import com.liferay.portal.kernel.search.facet.collector.FacetCollector;
import com.liferay.portal.kernel.search.facet.collector.TermCollector;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.kernel.util.DateFormatFactory;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.search.test.util.facet.BaseFacetTestCase;
import com.liferay.portal.util.DateFormatFactoryImpl;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseClassicModifiedFacetTestCase
extends BaseFacetTestCase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.setUpDateFormatFactoryUtil();
    }

    @Test
    public void testBuiltInNamedRanges() throws Exception {
        this.addDocument("17760704000000");
        this.addDocument("27760704000000");
        String[] configRanges = new String[]{"[past-hour TO *]", "[past-24-hours TO *]", "[past-week TO *]", "[past-month TO *]", "[past-year TO *]"};
        this.assertSearchFacet(helper -> {
            Facet facet = helper.addFacet(this::createFacet);
            this.setConfigurationRanges(facet, configRanges);
            helper.search();
            FacetCollector facetCollector = facet.getFacetCollector();
            List termCollectors = facetCollector.getTermCollectors();
            Assert.assertNotNull((Object)termCollectors);
            Assert.assertEquals((String)termCollectors.toString(), (long)configRanges.length, (long)termCollectors.size());
            for (TermCollector termCollector : termCollectors) {
                String term = termCollector.getTerm();
                Assert.assertTrue((boolean)term.contains("00 TO 20"));
            }
        });
    }

    protected Facet createFacet(SearchContext searchContext) {
        ModifiedFacet facet = new ModifiedFacet(searchContext);
        FacetConfiguration facetConfiguration = facet.getFacetConfiguration();
        facetConfiguration.setDataJSONObject(this.jsonFactory.createJSONObject());
        return facet;
    }

    protected JSONArray createRangeArray(String ... ranges) {
        JSONArray jsonArray = this.jsonFactory.createJSONArray();
        for (String range : ranges) {
            jsonArray.put(this.createRangeArrayElement(range));
        }
        return jsonArray;
    }

    protected JSONObject createRangeArrayElement(String range) {
        JSONObject jsonObject = this.jsonFactory.createJSONObject();
        jsonObject.put("range", range);
        return jsonObject;
    }

    @Override
    protected String getField() {
        return "modified";
    }

    protected void setConfigurationRanges(Facet facet, String ... ranges) {
        FacetConfiguration facetConfiguration = facet.getFacetConfiguration();
        JSONObject jsonObject = facetConfiguration.getData();
        jsonObject.put("ranges", this.createRangeArray(ranges));
    }

    protected void setUpDateFormatFactoryUtil() {
        DateFormatFactoryUtil dateFormatFactoryUtil = new DateFormatFactoryUtil();
        dateFormatFactoryUtil.setDateFormatFactory((DateFormatFactory)new DateFormatFactoryImpl());
    }
}

