/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.facet;

import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.search.facet.nested.NestedFacetFactory;
import com.liferay.portal.search.filter.ComplexQueryPartBuilderFactory;
import com.liferay.portal.search.internal.facet.NestedFacetImpl;
import com.liferay.portal.search.internal.facet.nested.NestedFacetFactoryImpl;
import com.liferay.portal.search.internal.filter.ComplexQueryPartBuilderFactoryImpl;
import com.liferay.portal.search.query.BooleanQuery;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.test.util.facet.BaseFacetTestCase;
import com.liferay.portal.search.test.util.facet.BaseSimpleFacetTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;

public abstract class BaseNestedFieldsFacetTestCase
extends BaseSimpleFacetTestCase {
    protected NestedFacetFactory nestedFacetFactory = new NestedFacetFactoryImpl();
    private final ComplexQueryPartBuilderFactory _complexQueryPartBuilderFactory = new ComplexQueryPartBuilderFactoryImpl();

    @Override
    protected void addDocument(String ... values) throws Exception {
        this.addDocument(DocumentCreationHelpers.oneDDMField(this.getField(), this.getNestedDocumentValueFieldName(), values));
    }

    @Override
    protected Facet createFacet(SearchContext searchContext) {
        NestedFacetImpl nestedFacetImpl = (NestedFacetImpl)this.nestedFacetFactory.newInstance(searchContext);
        this.initFacet((Facet)nestedFacetImpl);
        nestedFacetImpl.setFieldName(this.getValueFieldName());
        nestedFacetImpl.setFilterField(this.getFilterFieldName());
        nestedFacetImpl.setFilterValue(this.getField());
        nestedFacetImpl.setPath(this.getPath());
        return nestedFacetImpl;
    }

    @Override
    protected void filterUnmatched(BaseFacetTestCase.FacetTestHelper facetTestHelper, String presentButUnmatched) {
        facetTestHelper.defineRequest(searchRequestBuilder -> {
            BooleanQuery booleanQuery = this.queries.booleanQuery();
            booleanQuery.addMustNotQueryClauses(new Query[]{this.queries.term(this.getValueFieldName(), (Object)presentButUnmatched)});
            booleanQuery.addMustQueryClauses(new Query[]{this.queries.term(this.getFilterFieldName(), (Object)this.getField())});
            searchRequestBuilder.addComplexQueryPart(this._complexQueryPartBuilderFactory.builder().query((Query)this.queries.nested(this.getPath(), (Query)booleanQuery)).build());
        });
    }

    @Override
    protected String getField() {
        return "ddm__keyword__40635__Field14510226_en_US";
    }

    protected String getFilterFieldName() {
        return "ddmFieldArray.ddmFieldName";
    }

    protected String getNestedDocumentValueFieldName() {
        return "ddmFieldValueKeyword_en_US";
    }

    protected String getPath() {
        return "ddmFieldArray";
    }

    protected String getValueFieldName() {
        return "ddmFieldArray.ddmFieldValueKeyword_en_US";
    }

    @Override
    protected void select(Facet facet, String value, BaseFacetTestCase.FacetTestHelper facetTestHelper) {
        com.liferay.portal.search.facet.Facet osgiFacet = (com.liferay.portal.search.facet.Facet)facet;
        osgiFacet.select(new String[]{value});
    }
}

