/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.logging;

import com.liferay.portal.kernel.test.rule.MethodTestRule;
import com.liferay.portal.search.test.util.logging.ExpectedLog;
import com.liferay.portal.test.log.LogCapture;
import com.liferay.portal.test.log.LogEntry;
import com.liferay.portal.test.log.LoggerTestUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;

public class ExpectedLogMethodTestRule
extends MethodTestRule<Void> {
    public static final ExpectedLogMethodTestRule INSTANCE = new ExpectedLogMethodTestRule();
    private LogCapture _logCapture;
    private final MatcherBuilder _matcherBuilder = new MatcherBuilder();

    public void verify() {
        if (!this._matcherBuilder.isAnythingExpected()) {
            return;
        }
        Assert.assertThat(this.getlogEntries(), this._matcherBuilder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterMethod(org.junit.runner.Description description, Void unused, Object target) {
        ExpectedLog expectedLog = (ExpectedLog)description.getAnnotation(ExpectedLog.class);
        if (expectedLog == null) {
            return;
        }
        try {
            this.verify();
        }
        finally {
            this.closeCaptureHandler();
        }
    }

    protected Void beforeMethod(org.junit.runner.Description description, Object target) {
        ExpectedLog expectedLog = (ExpectedLog)description.getAnnotation(ExpectedLog.class);
        if (expectedLog == null) {
            return null;
        }
        this._matcherBuilder.clear();
        Class<?> clazz = expectedLog.expectedClass();
        ExpectedLog.Level level = expectedLog.expectedLevel();
        this._configure(clazz.getName(), Level.parse(level.name()));
        this._matcherBuilder.add(LogOutputMatcher.hasMessage((Matcher<String>)CoreMatchers.containsString((String)expectedLog.expectedLog())));
        return null;
    }

    protected void closeCaptureHandler() {
        if (this._logCapture == null) {
            return;
        }
        this._logCapture.close();
        this._logCapture = null;
    }

    protected List<LogEntry> getlogEntries() {
        if (this._logCapture != null) {
            return this._logCapture.getLogEntries();
        }
        return Collections.emptyList();
    }

    @Deprecated
    protected List<LogRecord> getLogRecords() {
        return Collections.emptyList();
    }

    protected void openCaptureHandler(String name, Level level) {
        this._logCapture = LoggerTestUtil.configureJDKLogger((String)name, (Level)level);
    }

    private void _configure(String name, Level level) {
        if (name == null || level == null) {
            return;
        }
        this.closeCaptureHandler();
        this.openCaptureHandler(name, level);
    }

    protected class MatcherBuilder<T> {
        protected final List<Matcher<T>> matchers = new ArrayList<Matcher<T>>();

        protected MatcherBuilder() {
        }

        protected void add(Matcher<T> matcher) {
            this.matchers.add(matcher);
        }

        protected Matcher<?> build() {
            if (this.matchers.size() == 1) {
                return this.matchers.get(0);
            }
            return CoreMatchers.allOf(new ArrayList<Matcher<T>>(this.matchers));
        }

        protected void clear() {
            this.matchers.clear();
        }

        protected boolean isAnythingExpected() {
            return !this.matchers.isEmpty();
        }
    }

    protected static class LogOutputMatcher<T extends List<LogEntry>>
    extends TypeSafeMatcher<T> {
        protected final Matcher<String> matcher;

        @Factory
        public static <T extends List<LogEntry>> Matcher<T> hasMessage(Matcher<String> matcher) {
            return new LogOutputMatcher<T>(matcher);
        }

        public LogOutputMatcher(Matcher<String> matcher) {
            this.matcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("log output with message ");
            description.appendDescriptionOf(this.matcher);
        }

        protected void describeMismatchSafely(T logRecords, Description description) {
            description.appendText("log output ");
            this.matcher.describeMismatch((Object)this.toString(logRecords), description);
        }

        protected boolean matchesSafely(T logEntries) {
            return this.matcher.matches((Object)this.toString(logEntries));
        }

        protected String toString(T logEntries) {
            Stream stream = logEntries.stream();
            return stream.map(LogEntry::getMessage).collect(Collectors.joining());
        }
    }
}

