/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.mappings;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.analysis.FieldQueryBuilder;
import com.liferay.portal.search.internal.analysis.SimpleKeywordTokenizer;
import com.liferay.portal.search.internal.analysis.SubstringFieldQueryBuilder;
import com.liferay.portal.search.test.util.mappings.BaseFieldQueryBuilderTestCase;
import java.util.Arrays;
import org.junit.Test;

public abstract class BaseSubstringFieldQueryBuilderTestCase
extends BaseFieldQueryBuilderTestCase {
    @Test
    public void testBasicWordMatches() throws Exception {
        this.addDocument("Nametag");
        this.addDocument("NA-META-G");
        this.addDocument("Tag Name");
        this.addDocument("TAG1");
        this.assertSearch("ame", 2);
        this.assertSearch("g", 4);
        this.assertSearch("META G", 4);
        this.assertSearch("meta", 2);
        this.assertSearch("META-G", 1);
        this.assertSearch("METAG", 1);
        this.assertSearch("METAG*", 1);
        this.assertSearch("nA mEtA g", 4);
        this.assertSearch("NA-META-G", 1);
        this.assertSearch("name tag", 3);
        this.assertSearch("name", 2);
        this.assertSearch("NaMe*", 2);
        this.assertSearch("nameTAG", 1);
        this.assertSearch("tag 1", 3);
        this.assertSearch("tag name", 3);
        this.assertSearch("tag1", 1);
        this.assertSearch("1", 1);
        this.assertSearch("*METAG", 1);
        this.assertSearch("\"meta\"", 2);
        this.assertSearch("\"tag1\"", 1);
        this.assertSearchNoHits("name-tag");
        this.assertSearchNoHits("tag2");
        this.assertSearchNoHits("\"NA G\"");
        this.assertSearchNoHits("\"na, meta, g\"");
        this.assertSearchNoHits("\"Name Tag\"");
        this.assertSearchNoHits("\"Tag (Name)\"");
        this.assertSearchNoHits("\"tag 1\"");
    }

    @Test
    public void testLuceneUnfriendlyTerms() throws Exception {
        this.assertSearchNoHits("*");
        this.assertSearchNoHits("&");
        this.assertSearchNoHits("^");
        this.assertSearchNoHits(":");
        this.assertSearchNoHits("-");
        this.assertSearchNoHits("!");
        this.assertSearchNoHits(")");
        this.assertSearchNoHits("(");
        this.assertSearchNoHits("]");
        this.assertSearchNoHits("[");
        this.assertSearchNoHits("}");
        this.assertSearchNoHits("{");
        this.assertSearchNoHits("\\");
        this.assertSearchNoHits(StringBundler.concat((String[])new String[]{"*", " ", "&", "-", " ", "!"}));
        this.assertSearchNoHits("AND");
        this.assertSearchNoHits("NOT");
        this.assertSearchNoHits("OR");
        this.assertSearchNoHits("ONE AND TWO OR THREE NOT FOUR");
        this.assertSearchNoHits("\"ONE\" NOT \"TWO\"");
    }

    @Test
    public void testMultiwordPhrasePrefixes() throws Exception {
        this.addDocument("Name Tags");
        this.addDocument("Names Tab");
        this.addDocument("Tag Names");
        this.addDocument("Tabs Names Tags");
        this.assertSearch("\"name ta*\"", 1);
        this.assertSearch("\"name tag*\"", 1);
        this.assertSearch("\"name tags*\"", 1);
        this.assertSearch("\"names ta*\"", 2);
        this.assertSearch("\"names tab*\"", 1);
        this.assertSearch("\"names tag*\"", 1);
        this.assertSearch("\"names tags*\"", 1);
        this.assertSearch("\"tabs name*\"", 1);
        this.assertSearch("\"tabs names ta*\"", 1);
        this.assertSearch("\"tabs names tag*\"", 1);
        this.assertSearch("\"tabs names tags*\"", 1);
        this.assertSearch("\"tabs names*\"", 1);
        this.assertSearch("\"tag na*\"", 1);
        this.assertSearch("\"tag name*\"", 1);
        this.assertSearch("\"tag names*\"", 1);
        this.assertSearchNoHits("\"name tab*\"");
        this.assertSearchNoHits("\"name tabs*\"");
        this.assertSearchNoHits("\"names tabs*\"");
        this.assertSearchNoHits("\"tab na*\"");
        this.assertSearchNoHits("\"tab names*\"");
        this.assertSearchNoHits("\"tabs na ta*\"");
        this.assertSearchNoHits("\"tabs name ta*\"");
        this.assertSearchNoHits("\"tags na ta*\"");
        this.assertSearchNoHits("\"tags names tabs*\"");
        this.assertSearchNoHits("\"tags names*\"");
        this.assertSearchNoHits("\"zz na*\"");
        this.assertSearchNoHits("\"zz name*\"");
        this.assertSearchNoHits("\"zz names*\"");
        this.assertSearchNoHits("\"zz ta*\"");
        this.assertSearchNoHits("\"zz tab*\"");
        this.assertSearchNoHits("\"zz tabs*\"");
        this.assertSearchNoHits("\"zz tag*\"");
        this.assertSearchNoHits("\"zz tags*\"");
    }

    @Test
    public void testNull() throws Exception {
        this.addDocument("null");
        this.addDocument("anulled");
        this.addDocument("The word null is in this sentence");
        this.addDocument("Ultimate Nullifier");
        this.addDocument("llun");
        this.assertSearchIgnoreRelevance("null", Arrays.asList("null", "anulled", "the word null is in this sentence", "ultimate nullifier"));
    }

    @Test
    public void testNumbers() throws Exception {
        this.addDocument("Nametag5");
        this.addDocument("2Tagname");
        this.addDocument("LETTERS ONLY");
        this.assertSearch("2", 1);
        this.assertSearch("2Tag", 1);
        this.assertSearch("2Tagname", 1);
        this.assertSearch("5", 1);
        this.assertSearch("Name", 2);
        this.assertSearch("Nametag", 1);
        this.assertSearch("Nametag5", 1);
        this.assertSearch("Tagname", 1);
        this.assertSearchNoHits("5Nametag");
        this.assertSearchNoHits("5Tagname");
        this.assertSearchNoHits("Nametag2");
        this.assertSearchNoHits("Nametag9");
        this.assertSearchNoHits("Tagname2");
        this.assertSearchNoHits("Tagname5");
        this.assertSearchNoHits("Tagname9");
    }

    @Test
    public void testParentheses() throws Exception {
        this.addDocument("401 k");
        this.addDocument("401(k)");
        this.assertSearch("(", 1);
        this.assertSearch("(k", 1);
        this.assertSearch("(k)", 1);
        this.assertSearch(")", 1);
        this.assertSearch("1", 2);
        this.assertSearch("1(", 1);
        this.assertSearch("1(k", 1);
        this.assertSearch("1(k)", 1);
        this.assertSearch("4", 2);
        this.assertSearch("401 k", 2);
        this.assertSearch("401", 2);
        this.assertSearch("401(k)", 1);
        this.assertSearch("k", 2);
        this.assertSearch("k)", 1);
        this.assertSearchNoHits("()");
        this.assertSearchNoHits("1k");
        this.assertSearchNoHits("401k");
    }

    @Test
    public void testPhrases() throws Exception {
        this.addDocument("Names of Tags");
        this.addDocument("More names of tags here");
        this.assertSearch("\"ags her\"  ame  \"mor\"", 2);
        this.assertSearch("\"ags here\"", 1);
        this.assertSearch("\"ames of tag\" \"here tags\"", 2);
        this.assertSearch("\"ames of tag\"", 2);
        this.assertSearch("\"here tags\"  ame  \"ore\"", 2);
        this.assertSearch("\"HERE\"", 1);
        this.assertSearch("\"More\"", 1);
        this.assertSearch("\"more\"", 1);
        this.assertSearch("\"ore name\" \"ags her\"", 1);
        this.assertSearch("\"ore name\" \"here tags\"", 1);
        this.assertSearch("\"TAGS\"", 2);
        this.assertSearchNoHits("\"  tags  \"");
    }

    @Test
    public void testStopwords() throws Exception {
        this.addDocument("Names of Tags");
        this.addDocument("More names of tags");
        this.assertSearch("of", 2);
        this.assertSearch("ags ames", 2);
        this.assertSearch("ames of tags", 2);
    }

    @Test
    public void testSubstrings() throws Exception {
        this.addDocument("Nametag");
        this.addDocument("NA-META-G");
        this.addDocument("Tag Name");
        this.addDocument("TAG1");
        this.assertSearch("*", 4);
        this.assertSearch("**", 4);
        this.assertSearch("***", 4);
        this.assertSearch("****", 4);
        this.assertSearch("me", 3);
        this.assertSearch("me*", 3);
        this.assertSearch("met", 2);
        this.assertSearch("Na", 3);
        this.assertSearch("NA*", 3);
        this.assertSearch("Namet", 1);
        this.assertSearch("namet*", 1);
        this.assertSearch("Ta", 4);
        this.assertSearch("Ta*", 4);
        this.assertSearch("tag", 3);
        this.assertSearch("*me", 3);
        this.assertSearch("*me*", 3);
        this.assertSearch("*met*", 2);
        this.assertSearch("*NA", 3);
        this.assertSearch("*NA*", 3);
        this.assertSearch("*namet", 1);
        this.assertSearch("*namet*", 1);
        this.assertSearch("*Ta", 4);
        this.assertSearch("*Ta*", 4);
    }

    @Test
    public void testWildcardCharacters() throws Exception {
        this.addDocument("AAA+BBB-CCC{DDD]");
        this.addDocument("AAA BBB CCC DDD");
        this.addDocument("M*A*S*H");
        this.addDocument("M... A... S... H");
        this.addDocument("Who? When? Where?");
        this.addDocument("Who. When. Where.");
        this.assertSearch("AAA+???-CCC?DDD]", Arrays.asList("aaa+bbb-ccc{ddd]"));
        this.assertSearch("AAA+*{DDD*", Arrays.asList("aaa+bbb-ccc{ddd]"));
        this.assertSearch("AA?+BB?-CC?{DD?]", Arrays.asList("aaa+bbb-ccc{ddd]"));
        this.assertSearch("AA*+BB*-CC*{DD*]", Arrays.asList("aaa+bbb-ccc{ddd]"));
        this.assertSearchIgnoreRelevance("M*A*S*H", Arrays.asList("m*a*s*h", "m... a... s... h"));
        this.assertSearchIgnoreRelevance("M A S H", Arrays.asList("m*a*s*h", "m... a... s... h", "aaa+bbb-ccc{ddd]", "aaa bbb ccc ddd", "who? when? where?", "who. when. where."));
        this.assertSearchIgnoreRelevance("M* A* *S *H", Arrays.asList("m*a*s*h", "m... a... s... h", "aaa+bbb-ccc{ddd]", "aaa bbb ccc ddd", "who? when? where?", "who. when. where."));
        this.assertSearchIgnoreRelevance("When?", Arrays.asList("who? when? where?", "who. when. where."));
        this.assertSearchIgnoreRelevance("Who? When?", Arrays.asList("who? when? where?", "who. when. where."));
        this.assertSearchIgnoreRelevance("Who? *en? Where?", Arrays.asList("who? when? where?", "who. when. where."));
        this.assertSearchIgnoreRelevance("Who? * Where?", Arrays.asList("who? when? where?", "who. when. where.", "aaa+bbb-ccc{ddd]", "aaa bbb ccc ddd", "m*a*s*h", "m... a... s... h"));
        this.assertSearchIgnoreRelevance("Who?   When?   Where?", Arrays.asList("who? when? where?", "who. when. where."));
        this.assertSearchIgnoreRelevance("Wh?? W?en? Wher??", Arrays.asList("who? when? where?", "who. when. where."));
        this.assertSearchIgnoreRelevance("Wh* W*en* Wher*", Arrays.asList("who? when? where?", "who. when. where."));
    }

    @Override
    protected FieldQueryBuilder createFieldQueryBuilder() {
        return new SubstringFieldQueryBuilder(){
            {
                this.keywordTokenizer = new SimpleKeywordTokenizer();
            }
        };
    }

    @Override
    protected String getField() {
        return "treePath";
    }

    protected String[] toLowerCase(String[] values) {
        String[] clone = (String[])values.clone();
        StringUtil.lowerCase((String[])clone);
        return clone;
    }

    @Override
    protected String[] transformFieldValues(String ... values) {
        return this.toLowerCase(values);
    }
}

