/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.mappings;

import com.liferay.portal.search.internal.analysis.SimpleKeywordTokenizer;
import com.liferay.portal.search.internal.query.QueriesImpl;
import com.liferay.portal.search.internal.query.field.AssetTagNamesFieldQueryBuilderFactory;
import com.liferay.portal.search.internal.query.field.DescriptionFieldQueryBuilder;
import com.liferay.portal.search.internal.query.field.FieldQueryBuilderFactoryImpl;
import com.liferay.portal.search.internal.query.field.FieldQueryFactoryImpl;
import com.liferay.portal.search.internal.query.field.SubstringFieldQueryBuilder;
import com.liferay.portal.search.internal.query.field.TitleFieldQueryBuilder;
import com.liferay.portal.search.query.field.FieldQueryBuilderFactory;
import com.liferay.portal.search.query.field.FieldQueryFactory;
import com.liferay.portal.search.query.field.QueryPreProcessConfiguration;
import org.mockito.Mockito;

public class LiferayFieldQueryFactoryFixture {
    private final DescriptionFieldQueryBuilder _descriptionFieldQueryBuilder;
    private final FieldQueryFactory _fieldQueryFactory;
    private final SubstringFieldQueryBuilder _substringFieldQueryBuilder;
    private final TitleFieldQueryBuilder _titleFieldQueryBuilder;

    public LiferayFieldQueryFactoryFixture() {
        QueriesImpl queriesImpl = new QueriesImpl();
        SimpleKeywordTokenizer simpleKeywordTokenizer = new SimpleKeywordTokenizer();
        this._descriptionFieldQueryBuilder = LiferayFieldQueryFactoryFixture.createDescriptionFieldQueryBuilder(simpleKeywordTokenizer, queriesImpl);
        this._substringFieldQueryBuilder = LiferayFieldQueryFactoryFixture.createSubstringFieldQueryBuilder(simpleKeywordTokenizer, queriesImpl);
        this._titleFieldQueryBuilder = LiferayFieldQueryFactoryFixture.createTitleFieldQueryBuilder(simpleKeywordTokenizer, queriesImpl);
        final FieldQueryBuilderFactoryImpl fieldQueryBuilderFactoryImpl = new FieldQueryBuilderFactoryImpl(){
            {
                this.descriptionFieldQueryBuilder = LiferayFieldQueryFactoryFixture.this._descriptionFieldQueryBuilder;
                this.queryPreProcessConfiguration = (QueryPreProcessConfiguration)Mockito.mock(QueryPreProcessConfiguration.class);
                this.substringFieldQueryBuilder = LiferayFieldQueryFactoryFixture.this._substringFieldQueryBuilder;
                this.titleFieldQueryBuilder = LiferayFieldQueryFactoryFixture.this._titleFieldQueryBuilder;
            }
        };
        final AssetTagNamesFieldQueryBuilderFactory assetTagNamesFieldQueryBuilderFactory = new AssetTagNamesFieldQueryBuilderFactory(){
            {
                this.titleQueryBuilder = LiferayFieldQueryFactoryFixture.this._titleFieldQueryBuilder;
            }
        };
        this._fieldQueryFactory = new FieldQueryFactoryImpl(){
            {
                this.descriptionFieldQueryBuilder = LiferayFieldQueryFactoryFixture.this._descriptionFieldQueryBuilder;
                this.addFieldQueryBuilderFactory((FieldQueryBuilderFactory)assetTagNamesFieldQueryBuilderFactory);
                this.addFieldQueryBuilderFactory((FieldQueryBuilderFactory)fieldQueryBuilderFactoryImpl);
            }
        };
    }

    public FieldQueryFactory getFieldQueryFactory() {
        return this._fieldQueryFactory;
    }

    protected static DescriptionFieldQueryBuilder createDescriptionFieldQueryBuilder(final SimpleKeywordTokenizer simpleKeywordTokenizer, final QueriesImpl queriesImpl) {
        return new DescriptionFieldQueryBuilder(){
            {
                this.keywordTokenizer = simpleKeywordTokenizer;
                this.queries = queriesImpl;
            }
        };
    }

    protected static SubstringFieldQueryBuilder createSubstringFieldQueryBuilder(final SimpleKeywordTokenizer simpleKeywordTokenizer, final QueriesImpl queriesImpl) {
        return new SubstringFieldQueryBuilder(){
            {
                this.keywordTokenizer = simpleKeywordTokenizer;
                this.queries = queriesImpl;
            }
        };
    }

    protected static TitleFieldQueryBuilder createTitleFieldQueryBuilder(final SimpleKeywordTokenizer simpleKeywordTokenizer, final QueriesImpl queriesImpl) {
        return new TitleFieldQueryBuilder(){
            {
                this.keywordTokenizer = simpleKeywordTokenizer;
                this.queries = queriesImpl;
            }
        };
    }
}

