/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.query;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.search.SearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.BooleanQuery;
import com.liferay.portal.search.query.IdsQuery;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.TermQuery;
import com.liferay.portal.search.sort.FieldSort;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.test.util.DocumentsAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.junit.Test;

public abstract class BaseIdsQueryTestCase
extends BaseIndexingTestCase {
    @Test
    public void testIdsQuery() {
        this.index(1, "alpha");
        this.index(2, "bravo");
        this.index(3, "charlie");
        this.index(4, "delta");
        IdsQuery idsQuery = this.queries.ids();
        idsQuery.addIds(new String[]{"1", "4"});
        FieldSort sort = this.sorts.field("userName", SortOrder.DESC);
        this.assertSearch((Query)idsQuery, arg_0 -> BaseIdsQueryTestCase.lambda$testIdsQuery$0((Sort)sort, arg_0), "[delta, alpha]");
    }

    @Test
    public void testIdsQueryBoost() {
        this.index(1, "alpha");
        this.index(2, "bravo");
        this.index(3, "charlie");
        this.index(4, "delta");
        BooleanQuery booleanQuery = this.queries.booleanQuery();
        IdsQuery idsQuery = this.queries.ids();
        idsQuery.addIds(new String[]{"4"});
        idsQuery.setBoost(Float.valueOf(1000.0f));
        TermQuery termQuery = this.queries.term("userName", (Object)"alpha");
        termQuery.setBoost(Float.valueOf(500.0f));
        booleanQuery.addShouldQueryClauses(new Query[]{idsQuery, termQuery});
        this.assertSearch((Query)booleanQuery, "[delta, alpha]");
    }

    protected void assertSearch(Query query, Consumer<SearchSearchRequest> consumer, String expected) {
        this.assertSearch(indexingTestHelper -> {
            SearchSearchRequest searchSearchRequest = this.getSearchSearchRequest(query);
            if (consumer != null) {
                consumer.accept(searchSearchRequest);
            }
            this.assertSearch(searchSearchRequest, expected);
        });
    }

    protected void assertSearch(Query query, String expected) {
        this.assertSearch(query, null, expected);
    }

    protected void assertSearch(SearchSearchRequest searchSearchRequest, String expected) {
        SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
        SearchSearchResponse searchSearchResponse = (SearchSearchResponse)searchEngineAdapter.execute((SearchRequest)searchSearchRequest);
        Stream<com.liferay.portal.search.document.Document> stream = this.getDocumentsStream(searchSearchResponse.getSearchHits());
        DocumentsAssert.assertValues(searchSearchResponse.getSearchRequestString(), stream, "userName", expected);
    }

    protected Stream<com.liferay.portal.search.document.Document> getDocumentsStream(SearchHits searchHits) {
        List list = searchHits.getSearchHits();
        Stream stream = list.stream();
        return stream.map(SearchHit::getDocument);
    }

    protected SearchSearchRequest getSearchSearchRequest(final Query query) {
        return new SearchSearchRequest(){
            {
                this.setIndexNames(new String[]{"_all"});
                this.setQuery(query);
            }
        };
    }

    protected void index(int uid, String userName) {
        this.addDocument((Document document) -> {
            document.addKeyword("uid", uid);
            document.addKeyword("userName", userName);
        });
    }

    private static /* synthetic */ void lambda$testIdsQuery$0(Sort sort, SearchSearchRequest searchSearchRequest) {
        searchSearchRequest.addSorts(new Sort[]{sort});
    }
}

