/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.query;

import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.test.util.DocumentsAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseMatchAllQueryTestCase
extends BaseIndexingTestCase {
    @Test
    public void testMatchAllQuery() {
        int count = 20;
        List<Double> list = IntStream.rangeClosed(1, count).mapToObj(Double::valueOf).collect(Collectors.toList());
        list.forEach(i -> this.addDocument(DocumentCreationHelpers.singleNumber("priority", i)));
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.withSearchRequestBuilder(new Consumer[]{this::addMatchAllQuery}).size(Integer.valueOf(30)).sorts(new Sort[]{this.sorts.field("priority")}));
            indexingTestHelper.search();
            indexingTestHelper.verifyResponse(searchResponse -> {
                SearchHits searchHits = searchResponse.getSearchHits();
                Assert.assertEquals((String)("Total hits: " + searchResponse.getRequestString()), (long)count, (long)searchHits.getTotalHits());
                DocumentsAssert.assertValues(searchResponse.getRequestString(), searchResponse.getDocumentsStream(), "priority", String.valueOf(list));
            });
        });
    }

    @Test
    public void testMatchAllQueryWithSize0() {
        int count = 20;
        IntStream.rangeClosed(1, count).forEach(i -> this.addDocument(DocumentCreationHelpers.singleNumber("priority", i)));
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.withSearchRequestBuilder(new Consumer[]{this::addMatchAllQuery}).size(Integer.valueOf(0)));
            indexingTestHelper.search();
            indexingTestHelper.verifyResponse(searchResponse -> {
                SearchHits searchHits = searchResponse.getSearchHits();
                Assert.assertEquals((String)("Total hits: " + searchResponse.getRequestString()), (long)count, (long)searchHits.getTotalHits());
                DocumentsAssert.assertValues(searchResponse.getRequestString(), searchResponse.getDocumentsStream(), "priority", "[]");
            });
        });
    }

    protected void addMatchAllQuery(SearchRequestBuilder searchRequestBuilder) {
        searchRequestBuilder.addComplexQueryPart(this.complexQueryPartBuilderFactory.builder().query((Query)this.queries.matchAll()).build());
    }
}

