/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.query;

import com.liferay.portal.json.JSONFactoryImpl;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.search.SearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.WrapperQuery;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class BaseWrapperQueryTestCase
extends BaseIndexingTestCase {
    private static final String _FIELD_NAME = "content";

    @BeforeClass
    public static void setUpClassJSONUtil() {
        JSONFactoryUtil jsonFactoryUtil = new JSONFactoryUtil();
        jsonFactoryUtil.setJSONFactory((JSONFactory)new JSONFactoryImpl());
    }

    @Test
    public void testWrapperQuery() {
        this.addDocuments("java eclipse", "java liferay", "java liferay eclipse", "C is the best language");
        this.assertSearch("liferay uses java", Arrays.asList("java liferay", "java liferay eclipse", "java eclipse"));
    }

    protected void addDocuments(String ... values) {
        this.addDocuments((String value) -> DocumentCreationHelpers.singleText(_FIELD_NAME, value), Arrays.asList(values));
    }

    protected void assertSearch(Object value, List<String> expectedValues) {
        this.assertSearch(indexingTestHelper -> {
            WrapperQuery wrapperQuery = this.queries.wrapper(JSONUtil.put((String)"match", (Object)JSONUtil.put((String)_FIELD_NAME, (Object)value)).toString());
            SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
            searchSearchRequest.setIndexNames(new String[]{"_all"});
            searchSearchRequest.setQuery((Query)wrapperQuery);
            searchSearchRequest.setSize(Integer.valueOf(30));
            SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
            SearchSearchResponse searchSearchResponse = (SearchSearchResponse)searchEngineAdapter.execute((SearchRequest)searchSearchRequest);
            SearchHits searchHits = searchSearchResponse.getSearchHits();
            Assert.assertEquals((String)"Total hits", (long)expectedValues.size(), (long)searchHits.getTotalHits());
            List searchHitsList = searchHits.getSearchHits();
            Assert.assertEquals((String)"Retrieved hits", (long)expectedValues.size(), (long)searchHitsList.size());
            ArrayList actualValues = new ArrayList();
            searchHitsList.forEach(searchHit -> {
                Document document = searchHit.getDocument();
                actualValues.add(document.getString(_FIELD_NAME));
            });
            Assert.assertEquals((String)("Retrieved hits ->" + actualValues), (Object)expectedValues.toString(), (Object)((Object)actualValues).toString());
        });
    }
}

