/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.web.facet;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.kernel.search.facet.util.FacetFactory;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.web.facet.SearchFacet;

public abstract class BaseSearchFacet
implements SearchFacet {
    private Facet _facet;
    private FacetConfiguration _facetConfiguration;

    @Override
    public String getClassName() {
        Class<?> clazz = this.getClass();
        return clazz.getName();
    }

    @Override
    public JSONObject getData() {
        return this._facetConfiguration.getData();
    }

    @Override
    public Facet getFacet() {
        return this._facet;
    }

    @Override
    public FacetConfiguration getFacetConfiguration() {
        return this._facetConfiguration;
    }

    @Override
    public String getId() {
        return this.getClassName();
    }

    @Override
    public String getOrder() {
        return "OrderHitsDesc";
    }

    @Override
    public String getTitle() {
        return this.getLabel();
    }

    @Override
    public double getWeight() {
        return this._facetConfiguration.getWeight();
    }

    @Override
    public void init(long companyId, String searchConfiguration) throws Exception {
        this.init(companyId, searchConfiguration, null);
    }

    @Override
    public void init(long companyId, String searchConfiguration, SearchContext searchContext) throws Exception {
        FacetConfiguration facetConfiguration = this._getFacetConfiguration(searchConfiguration);
        if (facetConfiguration == null) {
            facetConfiguration = this.getDefaultConfiguration(companyId);
        }
        this._facetConfiguration = facetConfiguration;
        Facet facet = null;
        if (searchContext != null) {
            FacetFactory facetFactory = this.getFacetFactory();
            facet = facetFactory.newInstance(searchContext);
            facet.setFacetConfiguration(facetConfiguration);
            if (facet instanceof com.liferay.portal.search.facet.Facet) {
                this._select((com.liferay.portal.search.facet.Facet)facet, searchContext);
            }
        }
        this._facet = facet;
    }

    @Override
    public boolean isStatic() {
        return this._facetConfiguration.isStatic();
    }

    protected abstract FacetFactory getFacetFactory();

    private FacetConfiguration _getFacetConfiguration(String configuration) throws JSONException {
        if (Validator.isNull((String)configuration)) {
            return null;
        }
        JSONObject configurationJSONObject = JSONFactoryUtil.createJSONObject((String)configuration);
        JSONArray facetsJSONArray = configurationJSONObject.getJSONArray("facets");
        if (facetsJSONArray == null) {
            return null;
        }
        for (int i = 0; i < facetsJSONArray.length(); ++i) {
            JSONObject facetJSONObject = facetsJSONArray.getJSONObject(i);
            String searchFacetId = facetJSONObject.getString("id");
            if (!searchFacetId.equals(this.getId())) continue;
            return this._toFacetConfiguration(facetJSONObject);
        }
        return null;
    }

    private void _select(com.liferay.portal.search.facet.Facet facet, SearchContext searchContext) {
        Object[] selections = StringUtil.split((String)GetterUtil.getString((Object)searchContext.getAttribute(this.getFieldName())));
        if (ArrayUtil.isNotEmpty((Object[])selections)) {
            facet.select((String[])selections);
        }
    }

    private FacetConfiguration _toFacetConfiguration(JSONObject facetJSONObject) {
        FacetConfiguration facetConfiguration = new FacetConfiguration();
        facetConfiguration.setClassName(facetJSONObject.getString("className"));
        if (facetJSONObject.has("data")) {
            facetConfiguration.setDataJSONObject(facetJSONObject.getJSONObject("data"));
        }
        facetConfiguration.setFieldName(facetJSONObject.getString("fieldName"));
        facetConfiguration.setLabel(facetJSONObject.getString("label"));
        facetConfiguration.setOrder(facetJSONObject.getString("order"));
        facetConfiguration.setStatic(facetJSONObject.getBoolean("static"));
        facetConfiguration.setWeight(facetJSONObject.getDouble("weight"));
        return facetConfiguration;
    }
}

