Liferay.Loader.define('portal-search-web$moment@2.24.0/src/lib/duration/valid', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        import toInt from '../utils/to-int';
        import indexOf from '../utils/index-of';
        import { Duration } from './constructor';
        import { createDuration } from './create';

        var ordering = ['year', 'quarter', 'month', 'week', 'day', 'hour', 'minute', 'second', 'millisecond'];

        export default function isDurationValid(m) {
            for (var key in m) {
                if (!(indexOf.call(ordering, key) !== -1 && (m[key] == null || !isNaN(m[key])))) {
                    return false;
                }
            }

            var unitHasDecimal = false;
            for (var i = 0; i < ordering.length; ++i) {
                if (m[ordering[i]]) {
                    if (unitHasDecimal) {
                        return false; // only allow non-integers for smallest unit
                    }
                    if (parseFloat(m[ordering[i]]) !== toInt(m[ordering[i]])) {
                        unitHasDecimal = true;
                    }
                }
            }

            return true;
        }

        export function isValid() {
            return this._isValid;
        }

        export function createInvalid() {
            return createDuration(NaN);
        }
    }
});
//# sourceMappingURL=valid.js.map