Liferay.Loader.define('portal-search-web$moment@2.29.4/src/locale/ss', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        //! moment.js locale configuration
        //! locale : siSwati [ss]
        //! author : Nicolai Davies<mail@nicolai.io> : https://github.com/nicolaidavies

        import moment from '../moment';

        export default moment.defineLocale('ss', {
            months: "Bhimbidvwane_Indlovana_Indlov'lenkhulu_Mabasa_Inkhwekhweti_Inhlaba_Kholwane_Ingci_Inyoni_Imphala_Lweti_Ingongoni".split('_'),
            monthsShort: 'Bhi_Ina_Inu_Mab_Ink_Inh_Kho_Igc_Iny_Imp_Lwe_Igo'.split('_'),
            weekdays: 'Lisontfo_Umsombuluko_Lesibili_Lesitsatfu_Lesine_Lesihlanu_Umgcibelo'.split('_'),
            weekdaysShort: 'Lis_Umb_Lsb_Les_Lsi_Lsh_Umg'.split('_'),
            weekdaysMin: 'Li_Us_Lb_Lt_Ls_Lh_Ug'.split('_'),
            weekdaysParseExact: true,
            longDateFormat: {
                LT: 'h:mm A',
                LTS: 'h:mm:ss A',
                L: 'DD/MM/YYYY',
                LL: 'D MMMM YYYY',
                LLL: 'D MMMM YYYY h:mm A',
                LLLL: 'dddd, D MMMM YYYY h:mm A'
            },
            calendar: {
                sameDay: '[Namuhla nga] LT',
                nextDay: '[Kusasa nga] LT',
                nextWeek: 'dddd [nga] LT',
                lastDay: '[Itolo nga] LT',
                lastWeek: 'dddd [leliphelile] [nga] LT',
                sameElse: 'L'
            },
            relativeTime: {
                future: 'nga %s',
                past: 'wenteka nga %s',
                s: 'emizuzwana lomcane',
                ss: '%d mzuzwana',
                m: 'umzuzu',
                mm: '%d emizuzu',
                h: 'lihora',
                hh: '%d emahora',
                d: 'lilanga',
                dd: '%d emalanga',
                M: 'inyanga',
                MM: '%d tinyanga',
                y: 'umnyaka',
                yy: '%d iminyaka'
            },
            meridiemParse: /ekuseni|emini|entsambama|ebusuku/,
            meridiem: function (hours, minutes, isLower) {
                if (hours < 11) {
                    return 'ekuseni';
                } else if (hours < 15) {
                    return 'emini';
                } else if (hours < 19) {
                    return 'entsambama';
                } else {
                    return 'ebusuku';
                }
            },
            meridiemHour: function (hour, meridiem) {
                if (hour === 12) {
                    hour = 0;
                }
                if (meridiem === 'ekuseni') {
                    return hour;
                } else if (meridiem === 'emini') {
                    return hour >= 11 ? hour : hour + 12;
                } else if (meridiem === 'entsambama' || meridiem === 'ebusuku') {
                    if (hour === 0) {
                        return 0;
                    }
                    return hour + 12;
                }
            },
            dayOfMonthOrdinalParse: /\d{1,2}/,
            ordinal: '%d',
            week: {
                dow: 1, // Monday is the first day of the week.
                doy: 4 // The week that contains Jan 4th is the first week of the year.
            }
        });
    }
});
//# sourceMappingURL=ss.js.map