/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.search.internal.spi.model.index.contributor;

import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentContributor;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.service.GroupLocalService;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Michael C. Han
 */
@Component(
	immediate = true, property = "service.ranking:Integer=10000",
	service = DocumentContributor.class
)
public class GroupedModelDocumentContributor
	implements DocumentContributor<GroupedModel> {

	@Override
	public void contribute(
		Document document, BaseModel<GroupedModel> baseModel) {

		if (!(baseModel instanceof GroupedModel)) {
			return;
		}

		GroupedModel groupedModel = (GroupedModel)baseModel;

		document.addKeyword(
			Field.GROUP_ID,
			GroupUtil.getSiteGroupId(
				groupLocalService, groupedModel.getGroupId()));

		document.addKeyword(Field.SCOPE_GROUP_ID, groupedModel.getGroupId());
	}

	@Reference
	protected GroupLocalService groupLocalService;

}