/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal;

import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.search.BaseSearchEngineConfigurator;
import com.liferay.portal.kernel.search.IndexSearcher;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.SearchEngine;
import com.liferay.portal.kernel.search.SearchEngineHelper;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={})
public class DefaultSearchEngineConfigurator
extends BaseSearchEngineConfigurator {
    @Reference
    private DestinationFactory _destinationFactory;
    @Reference
    private IndexSearcher _indexSearcher;
    @Reference
    private IndexWriter _indexWriter;
    @Reference
    private MessageBus _messageBus;
    @Reference
    private SearchEngine _searchEngine;
    @Reference
    private SearchEngineHelper _searchEngineHelper;

    @Activate
    protected void activate() {
        this.setDestinationFactory(this._destinationFactory);
        this.setMessageBus(this._messageBus);
        this.setSearchEngines(HashMapBuilder.put((Object)"GENERIC_ENGINE", (Object)this._searchEngine).build());
        this.afterPropertiesSet();
    }

    @Deactivate
    protected void deactivate() {
        this.destroy();
    }

    protected String getDefaultSearchEngineId() {
        return "SYSTEM_ENGINE";
    }

    protected IndexSearcher getIndexSearcher() {
        return this._indexSearcher;
    }

    protected IndexWriter getIndexWriter() {
        return this._indexWriter;
    }

    protected ClassLoader getOperatingClassLoader() {
        return PortalClassLoaderUtil.getClassLoader();
    }

    protected SearchEngineHelper getSearchEngineHelper() {
        return this._searchEngineHelper;
    }
}

