/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.petra.concurrent.NoticeableExecutorService;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchEngineHelperUtil;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.commons.lang.time.StopWatch;
import org.osgi.framework.BundleContext;

public class SearchEngineInitializer
implements Runnable {
    private static final Log _log = LogFactoryUtil.getLog(SearchEngineInitializer.class);
    private final BundleContext _bundleContext;
    private final long _companyId;
    private boolean _finished;
    private ServiceTrackerList<Indexer<?>> _indexers;
    private final PortalExecutorManager _portalExecutorManager;
    private final Set<String> _usedSearchEngineIds = new HashSet<String>();

    public SearchEngineInitializer(BundleContext bundleContext, long companyId, PortalExecutorManager portalExecutorManager) {
        this._bundleContext = bundleContext;
        this._companyId = companyId;
        this._portalExecutorManager = portalExecutorManager;
    }

    public Set<String> getUsedSearchEngineIds() {
        return this._usedSearchEngineIds;
    }

    public void halt() {
    }

    public boolean isFinished() {
        return this._finished;
    }

    public void reindex() {
        this.reindex(0);
    }

    public void reindex(int delay) {
        this._reIndex(delay);
    }

    @Override
    public void run() {
        this.reindex(PropsValues.INDEX_ON_STARTUP_DELAY);
    }

    protected void reindex(Indexer<?> indexer) throws Exception {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Reindexing of " + indexer.getClassName() + " entities started"));
        }
        indexer.reindex(new String[]{String.valueOf(this._companyId)});
        this._usedSearchEngineIds.add(indexer.getSearchEngineId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Reindexing of ", indexer.getClassName(), " entities completed in ", stopWatch.getTime() / 1000L, " seconds"}));
        }
    }

    private void _reIndex(int delay) {
        block12: {
            block11: {
                if (IndexWriterHelperUtil.isIndexReadOnly()) {
                    return;
                }
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Reindexing started");
                }
                if (delay < 0) {
                    delay = 0;
                }
                try {
                    if (delay > 0) {
                        Thread.sleep(1000L * (long)delay);
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (!_log.isDebugEnabled()) break block11;
                    _log.debug((Throwable)interruptedException);
                }
            }
            NoticeableExecutorService executorService = this._portalExecutorManager.getPortalExecutor(SearchEngineInitializer.class.getName());
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            try {
                SearchEngineHelperUtil.removeCompany((long)this._companyId);
                SearchEngineHelperUtil.initialize((long)this._companyId);
                final long backgroundTaskId = BackgroundTaskThreadLocal.getBackgroundTaskId();
                ArrayList<FutureTask<Void>> futureTasks = new ArrayList<FutureTask<Void>>();
                this._indexers = this._companyId == 0L ? ServiceTrackerListFactory.open((BundleContext)this._bundleContext, Indexer.class, (String)"(system.index=true)") : ServiceTrackerListFactory.open((BundleContext)this._bundleContext, Indexer.class, (String)"(!(system.index=true))");
                for (final Indexer indexer : this._indexers) {
                    FutureTask<Void> futureTask = new FutureTask<Void>(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            try (SafeCloseable safeCloseable = BackgroundTaskThreadLocal.setBackgroundTaskIdWithSafeCloseable((long)backgroundTaskId);){
                                SearchEngineInitializer.this.reindex(indexer);
                                Void void_ = null;
                                return void_;
                            }
                        }
                    });
                    executorService.submit(futureTask);
                    futureTasks.add(futureTask);
                }
                this._indexers.close();
                for (FutureTask futureTask : futureTasks) {
                    futureTask.get();
                }
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Reindexing completed in " + stopWatch.getTime() / 1000L + " seconds"));
                }
            }
            catch (Exception exception) {
                _log.error((Object)"Error encountered while reindexing", (Throwable)exception);
                if (!_log.isInfoEnabled()) break block12;
                _log.info((Object)"Reindexing failed");
            }
        }
        this._finished = true;
    }
}

