/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.aggregation.pipeline;

import com.liferay.portal.search.aggregation.pipeline.BucketScriptPipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregationVisitor;
import com.liferay.portal.search.internal.aggregation.pipeline.BasePipelineAggregation;
import com.liferay.portal.search.script.Script;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BucketScriptPipelineAggregationImpl
extends BasePipelineAggregation
implements BucketScriptPipelineAggregation {
    private final Map<String, String> _bucketsPathsMap = new HashMap<String, String>();
    private String _format;
    private final Script _script;

    public BucketScriptPipelineAggregationImpl(String name, Script script) {
        super(name);
        this._script = script;
    }

    public BucketScriptPipelineAggregationImpl(String name, Script script, Map<String, String> bucketsPathsMap) {
        super(name);
        this._script = script;
        this._bucketsPathsMap.putAll(bucketsPathsMap);
    }

    public <T> T accept(PipelineAggregationVisitor<T> pipelineAggregationVisitor) {
        return (T)pipelineAggregationVisitor.visit((BucketScriptPipelineAggregation)this);
    }

    public void addBucketPath(String paramName, String bucketPath) {
        this._bucketsPathsMap.put(paramName, bucketPath);
    }

    public Map<String, String> getBucketsPathsMap() {
        return Collections.unmodifiableMap(this._bucketsPathsMap);
    }

    public String getFormat() {
        return this._format;
    }

    public Script getScript() {
        return this._script;
    }

    public void setFormat(String format) {
        this._format = format;
    }
}

