/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.asset;

import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.portal.kernel.search.SearchEngineHelper;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.asset.SearchableAssetClassNamesProvider;
import com.liferay.portal.search.internal.asset.AssetRendererFactoryRegistry;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SearchableAssetClassNamesProvider.class})
public class SearchableAssetClassNamesProviderImpl
implements SearchableAssetClassNamesProvider {
    @Reference
    protected AssetRendererFactoryRegistry assetRendererFactoryRegistry;
    @Reference
    protected SearchEngineHelper searchEngineHelper;

    public String[] getClassNames(long companyId) {
        ArrayList<String> classNames = new ArrayList<String>();
        List<AssetRendererFactory<?>> assetRendererFactories = this.assetRendererFactoryRegistry.getAssetRendererFactories(companyId);
        for (AssetRendererFactory<?> assetRendererFactory : assetRendererFactories) {
            if (!assetRendererFactory.isSearchable()) continue;
            String className = assetRendererFactory.getClassName();
            if (!ArrayUtil.contains((String[])this.searchEngineHelper.getEntryClassNames(), (String)className, (boolean)false)) continue;
            classNames.add(className);
        }
        for (String searchEngineHelperEntryClassName : this.searchEngineHelper.getEntryClassNames()) {
            if (!searchEngineHelperEntryClassName.startsWith("com.liferay.object.model.ObjectDefinition#")) continue;
            classNames.add(searchEngineHelperEntryClassName);
        }
        return classNames.toArray(new String[0]);
    }
}

