/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.background.task;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatus;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusMessageTranslator;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Set;

public class ReindexBackgroundTaskStatusMessageTranslator
implements BackgroundTaskStatusMessageTranslator {
    public void translate(BackgroundTaskStatus backgroundTaskStatus, Message message) {
        long[] companyIds;
        String phase = message.getString("phase");
        if (Validator.isNotNull((String)phase)) {
            this._setPhaseAttributes(backgroundTaskStatus, message);
            return;
        }
        phase = GetterUtil.getString((Object)backgroundTaskStatus.getAttribute("phase"));
        String className = message.getString("className");
        backgroundTaskStatus.setAttribute("className", (Serializable)((Object)className));
        long count = message.getLong("count");
        backgroundTaskStatus.setAttribute("count", (Serializable)Long.valueOf(count));
        long total = message.getLong("total");
        backgroundTaskStatus.setAttribute("total", (Serializable)Long.valueOf(total));
        int companyCount = 0;
        for (long companyId : companyIds = GetterUtil.getLongValues((Object)backgroundTaskStatus.getAttribute("companyIds"))) {
            long currentCompanyId;
            if (companyId == (currentCompanyId = GetterUtil.getLong((Object)backgroundTaskStatus.getAttribute("companyId")))) break;
            ++companyCount;
        }
        int percentage = 100;
        if (phase.equals("portalStart")) {
            String lastIndexer = GetterUtil.getString((Object)backgroundTaskStatus.getAttribute("lastIndexer"));
            int indexerCount = GetterUtil.getInteger((Object)backgroundTaskStatus.getAttribute("indexerCount"));
            if (Validator.isNull((String)lastIndexer)) {
                backgroundTaskStatus.setAttribute("lastIndexer", (Serializable)((Object)className));
            } else if (!lastIndexer.equals(className)) {
                backgroundTaskStatus.setAttribute("indexerCount", (Serializable)Integer.valueOf(++indexerCount));
                backgroundTaskStatus.setAttribute("lastIndexer", (Serializable)((Object)className));
            }
            Set indexers = IndexerRegistryUtil.getIndexers();
            percentage = this._getPercentage(companyCount, companyIds.length, indexerCount, indexers.size(), count, total);
        } else if (phase.equals("singleStart")) {
            percentage = this._getPercentage(companyCount, companyIds.length, 0, 1, count, total);
        }
        backgroundTaskStatus.setAttribute("percentage", (Serializable)((Object)String.valueOf(percentage)));
    }

    private int _getPercentage(int companyCount, int companyTotal, int indexerCount, int indexerTotal, long documentCount, long documentTotal) {
        if (companyTotal <= 0 || indexerTotal <= 0) {
            return 100;
        }
        double indexerPercentage = 1.0;
        if (documentTotal != 0L) {
            indexerPercentage = (double)documentCount / (double)documentTotal;
        }
        double companyPercentage = ((double)indexerCount + indexerPercentage) / (double)indexerTotal;
        double totalPercentage = ((double)companyCount + companyPercentage) / (double)companyTotal;
        return (int)Math.min(Math.ceil(totalPercentage * 100.0), 100.0);
    }

    private void _setPhaseAttributes(BackgroundTaskStatus backgroundTaskStatus, Message message) {
        backgroundTaskStatus.setAttribute("companyId", (Serializable)Long.valueOf(message.getLong("companyId")));
        backgroundTaskStatus.setAttribute("companyIds", (Serializable)GetterUtil.getLongValues((Object)message.get("companyIds")));
        backgroundTaskStatus.setAttribute("phase", (Serializable)((Object)message.getString("phase")));
    }
}

