/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.context;

import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.context.SearchContextFactory;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import org.osgi.service.component.annotations.Component;

@Component(service={SearchContextFactory.class})
public class SearchContextFactoryImpl
implements SearchContextFactory {
    public SearchContext getSearchContext(long[] assetCategoryIds, String[] assetTagNames, long companyId, String keywords, Layout layout, Locale locale, Map<String, String[]> parameters, long scopeGroupId, TimeZone timeZone, long userId) {
        String[] scopes;
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        searchContext.setGroupIds(new long[]{scopeGroupId});
        searchContext.setLayout(layout);
        searchContext.setLocale(locale);
        searchContext.setTimeZone(timeZone);
        searchContext.setUserId(userId);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
            Object[] values = entry.getValue();
            if (!ArrayUtil.isNotEmpty((Object[])values)) continue;
            String name = entry.getKey();
            if (values.length == 1) {
                attributes.put(name, values[0]);
                continue;
            }
            attributes.put(name, values);
        }
        if (!parameters.containsKey("groupId") && (scopes = parameters.get("scope")) != null) {
            String groupId = "0";
            if (Objects.equals(scopes[0], "this-site")) {
                groupId = String.valueOf(scopeGroupId);
            }
            attributes.put("groupId", groupId);
        }
        searchContext.setAttributes(attributes);
        searchContext.setAssetCategoryIds(assetCategoryIds);
        searchContext.setAssetTagNames(assetTagNames);
        searchContext.setKeywords(keywords);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setLocale(locale);
        return searchContext;
    }
}

