/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.document;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.document.Field;
import com.liferay.portal.search.geolocation.GeoLocationPoint;
import com.liferay.portal.search.internal.document.FieldImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DocumentImpl
implements Document {
    private final Map<String, Field> _fields;

    public DocumentImpl() {
        this._fields = new LinkedHashMap<String, Field>();
    }

    public DocumentImpl(DocumentImpl documentImpl) {
        this._fields = new LinkedHashMap<String, Field>(documentImpl._fields);
    }

    public Boolean getBoolean(String name) {
        return GetterUtil.getBoolean((Object)this.getValue(name));
    }

    public List<Boolean> getBooleans(String name) {
        return this.getValues(name, GetterUtil::getBoolean);
    }

    public String getDate(String name) {
        return this.getValue(name, String::valueOf);
    }

    public List<String> getDates(String name) {
        return this.getValues(name, String::valueOf);
    }

    public Double getDouble(String name) {
        return this.getValue(name, GetterUtil::getDouble);
    }

    public List<Double> getDoubles(String name) {
        return this.getValues(name, GetterUtil::getDouble);
    }

    public Map<String, Field> getFields() {
        return Collections.unmodifiableMap(this._fields);
    }

    public Float getFloat(String name) {
        return this.getValue(name, GetterUtil::getFloat);
    }

    public List<Float> getFloats(String name) {
        return this.getValues(name, GetterUtil::getFloat);
    }

    public GeoLocationPoint getGeoLocationPoint(String name) {
        return this.getValue(name, value -> (GeoLocationPoint)value);
    }

    public List<GeoLocationPoint> getGeoLocationPoints(String name) {
        return this.getValues(name, value -> (GeoLocationPoint)value);
    }

    public Integer getInteger(String name) {
        return this.getValue(name, GetterUtil::getInteger);
    }

    public List<Integer> getIntegers(String name) {
        return this.getValues(name, GetterUtil::getInteger);
    }

    public Long getLong(String name) {
        return this.getValue(name, GetterUtil::getLong);
    }

    public List<Long> getLongs(String name) {
        return this.getValues(name, GetterUtil::getLong);
    }

    public String getString(String name) {
        return this.getValue(name, String::valueOf);
    }

    public List<String> getStrings(String name) {
        return this.getValues(name, String::valueOf);
    }

    public Object getValue(String name) {
        Field field = this._fields.get(name);
        if (field == null) {
            return null;
        }
        return field.getValue();
    }

    public <T> T getValue(String name, Function<Object, T> function) {
        Object value = this.getValue(name);
        if (value != null) {
            return function.apply(value);
        }
        return null;
    }

    public List<Object> getValues(String name) {
        Field field = this._fields.get(name);
        if (field == null) {
            return Collections.emptyList();
        }
        return field.getValues();
    }

    public <T> List<T> getValues(String name, Function<Object, T> function) {
        List<Object> values = this.getValues(name);
        Stream stream = values.stream();
        return stream.map(function).collect(Collectors.toList());
    }

    public void setFieldValues(String name, Collection<Object> values) {
        if (values == null || values.isEmpty()) {
            this._removeField(name);
        } else {
            this._putField(name, values);
        }
    }

    public String toString() {
        return this._fields.toString();
    }

    public void unsetField(String name) {
        this._removeField(name);
    }

    protected void setFieldValue(String name, Object value) {
        if (this._isEmpty(value)) {
            this._removeField(name);
        } else {
            this._putField(name, Collections.singleton(value));
        }
    }

    protected void setFieldValues(String name, Object[] values) {
        this.setFieldValues(name, this._toCollection(values));
    }

    private boolean _isEmpty(Object value) {
        Collection collection;
        if (value == null) {
            return true;
        }
        return value instanceof Collection && (collection = (Collection)value).isEmpty();
    }

    private Field _putField(String name, Collection<Object> values) {
        return this._fields.put(name, new FieldImpl(name, values));
    }

    private Field _removeField(String name) {
        return this._fields.remove(name);
    }

    private Collection<Object> _toCollection(Object[] values) {
        if (ArrayUtil.isEmpty((Object[])values) || values.length == 1 && values[0] == null) {
            return null;
        }
        return Arrays.asList(values);
    }
}

