/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.expando;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoValue;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoValueLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.search.expando.ExpandoBridgeIndexer;
import com.liferay.portlet.expando.model.impl.ExpandoValueImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ExpandoBridgeIndexer.class})
public class ExpandoBridgeIndexerImpl
implements ExpandoBridgeIndexer {
    protected static final String FIELD_NAMESPACE = "expando";
    private static final Log _log = LogFactoryUtil.getLog(ExpandoBridgeIndexerImpl.class);
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoValueLocalService _expandoValueLocalService;

    public void addAttributes(Document document, ExpandoBridge expandoBridge) {
        if (expandoBridge == null) {
            return;
        }
        try {
            this.doAddAttributes(document, expandoBridge);
        }
        catch (SystemException systemException) {
            _log.error((Throwable)systemException);
        }
    }

    public String encodeFieldName(ExpandoColumn expandoColumn) {
        StringBundler sb = new StringBundler(7);
        sb.append(FIELD_NAMESPACE);
        sb.append("__");
        if (this._getIndexType(expandoColumn) == 2) {
            sb.append("keyword__");
        }
        sb.append(StringUtil.toLowerCase((String)"CUSTOM_FIELDS"));
        sb.append("__");
        sb.append(expandoColumn.getName());
        sb.append(this.getNumericSuffix(expandoColumn.getType()));
        return sb.toString();
    }

    public String getNumericSuffix(int columnType) {
        if (columnType == 5 || columnType == 6) {
            return "_double";
        }
        if (columnType == 7 || columnType == 8) {
            return "_float";
        }
        if (columnType == 9 || columnType == 10) {
            return "_integer";
        }
        if (columnType == 11 || columnType == 12) {
            return "_long";
        }
        if (columnType == 13 || columnType == 14) {
            return "_short";
        }
        return "";
    }

    protected void addAttribute(Document document, ExpandoColumn expandoColumn, Map<Long, ExpandoValue> expandoValues) throws PortalException {
        ExpandoValue expandoValue = expandoValues.get(expandoColumn.getColumnId());
        boolean hasValue = true;
        if (expandoValue == null) {
            expandoValue = new ExpandoValueImpl();
            expandoValue.setColumnId(expandoColumn.getColumnId());
            expandoValue.setData(expandoColumn.getDefaultData());
            hasValue = false;
        }
        String fieldName = this.encodeFieldName(expandoColumn);
        int indexType = this._getIndexType(expandoColumn);
        int type = expandoColumn.getType();
        if (type == 1) {
            document.addKeyword(fieldName, expandoValue.getBoolean());
        } else if (type == 2) {
            if (hasValue) {
                document.addKeyword(fieldName, expandoValue.getBooleanArray());
            } else {
                document.addKeyword(fieldName, new boolean[0]);
            }
        } else if (type == 3) {
            document.addDate(fieldName, expandoValue.getDate());
        } else if (type == 5 || type == 6) {
            Field field = new Field(fieldName, "0.0");
            if (type == 5) {
                field = new Field(fieldName, String.valueOf(expandoValue.getDouble()));
            } else if (hasValue) {
                field = new Field(fieldName, ArrayUtil.toStringArray((double[])expandoValue.getDoubleArray()));
            }
            field.setNumeric(true);
            field.setNumericClass(Double.class);
            document.add(field);
        } else if (type == 7 || type == 8) {
            Field field = new Field(fieldName, "0.0");
            if (type == 7) {
                field = new Field(fieldName, String.valueOf(expandoValue.getFloat()));
            } else if (hasValue) {
                field = new Field(fieldName, ArrayUtil.toStringArray((float[])expandoValue.getFloatArray()));
            }
            field.setNumeric(true);
            field.setNumericClass(Float.class);
            document.add(field);
        } else if (type == 21) {
            JSONObject jsonObject = expandoValue.getGeolocationJSONObject();
            double latitude = jsonObject.getDouble("latitude");
            double longitude = jsonObject.getDouble("longitude");
            document.addGeoLocation(fieldName.concat("_geolocation"), latitude, longitude);
        } else if (type == 9 || type == 10) {
            Field field = new Field(fieldName, "0");
            if (type == 9) {
                field = new Field(fieldName, String.valueOf(expandoValue.getInteger()));
            } else if (hasValue) {
                field = new Field(fieldName, ArrayUtil.toStringArray((int[])expandoValue.getIntegerArray()));
            }
            field.setNumeric(true);
            field.setNumericClass(Integer.class);
            document.add(field);
        } else if (type == 11 || type == 12) {
            Field field = new Field(fieldName, "0");
            if (type == 11) {
                field = new Field(fieldName, String.valueOf(expandoValue.getLong()));
            } else if (hasValue) {
                field = new Field(fieldName, ArrayUtil.toStringArray((long[])expandoValue.getLongArray()));
            }
            field.setNumeric(true);
            field.setNumericClass(Long.class);
            document.add(field);
        } else if (type == 17) {
            document.addKeyword(fieldName, String.valueOf(expandoValue.getNumber()));
        } else if (type == 18) {
            if (hasValue) {
                document.addKeyword(fieldName, ArrayUtil.toStringArray((Object[])expandoValue.getNumberArray()));
            } else {
                document.addKeyword(fieldName, new long[0]);
            }
        } else if (type == 13 || type == 14) {
            Field field = new Field(fieldName, "0");
            if (type == 13) {
                field = new Field(fieldName, String.valueOf(expandoValue.getShort()));
            } else if (hasValue) {
                field = new Field(fieldName, ArrayUtil.toStringArray((short[])expandoValue.getShortArray()));
            }
            field.setNumeric(true);
            field.setNumericClass(Short.class);
            document.add(field);
        } else if (type == 15) {
            if (indexType == 2) {
                document.addKeyword(fieldName, expandoValue.getString());
            } else {
                document.addText(fieldName, expandoValue.getString());
            }
        } else if (type == 16) {
            if (hasValue) {
                if (indexType == 2) {
                    document.addKeyword(fieldName, expandoValue.getStringArray());
                } else {
                    document.addText(fieldName, StringUtil.merge((Object[])expandoValue.getStringArray(), (String)" "));
                }
            } else if (indexType == 2) {
                document.addKeyword(fieldName, "");
            } else {
                document.addText(fieldName, "");
            }
        } else if (type == 20 && hasValue) {
            if (indexType == 2) {
                document.addLocalizedKeyword(fieldName, expandoValue.getStringMap());
            } else {
                document.addLocalizedText(fieldName, expandoValue.getStringMap());
            }
        }
    }

    protected void doAddAttributes(Document document, ExpandoBridge expandoBridge) {
        List expandoColumns = this._expandoColumnLocalService.getDefaultTableColumns(expandoBridge.getCompanyId(), expandoBridge.getClassName());
        if (ListUtil.isEmpty((List)expandoColumns)) {
            return;
        }
        ArrayList<ExpandoColumn> indexedColumns = new ArrayList<ExpandoColumn>();
        for (ExpandoColumn expandoColumn : expandoColumns) {
            int indexType = this._getIndexType(expandoColumn);
            if (indexType == 0) continue;
            indexedColumns.add(expandoColumn);
        }
        if (indexedColumns.isEmpty()) {
            return;
        }
        List expandoValues = this._expandoValueLocalService.getRowValues(expandoBridge.getCompanyId(), expandoBridge.getClassName(), "CUSTOM_FIELDS", expandoBridge.getClassPK(), -1, -1);
        HashMap<Long, ExpandoValue> expandoValuesMap = new HashMap<Long, ExpandoValue>();
        for (ExpandoValue expandoValue : expandoValues) {
            expandoValuesMap.put(expandoValue.getColumnId(), expandoValue);
        }
        for (ExpandoColumn expandoColumn : indexedColumns) {
            try {
                this.addAttribute(document, expandoColumn, expandoValuesMap);
            }
            catch (Exception exception) {
                _log.error((Object)("Indexing " + expandoColumn.getName()), (Throwable)exception);
            }
        }
    }

    private int _getIndexType(ExpandoColumn expandoColumn) {
        UnicodeProperties unicodeProperties = expandoColumn.getTypeSettingsProperties();
        return GetterUtil.getInteger((String)unicodeProperties.getProperty("index-type"));
    }
}

