/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.expando.helper;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.util.ExpandoBridgeFactory;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.expando.ExpandoBridgeIndexer;
import com.liferay.portal.search.internal.expando.helper.ExpandoQueryContributorHelper;
import com.liferay.portal.search.internal.indexer.IndexerProvidedClausesUtil;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ExpandoQueryContributorHelper.class})
public class ExpandoQueryContributorHelperImpl
implements ExpandoQueryContributorHelper {
    protected Localization localization;
    private ExpandoBridgeFactory _expandoBridgeFactory;
    private ExpandoBridgeIndexer _expandoBridgeIndexer;
    private ExpandoColumnLocalService _expandoColumnLocalService;

    @Override
    public void contribute(String keywords, BooleanQuery booleanQuery, Collection<String> classNames, SearchContext searchContext) {
        if (IndexerProvidedClausesUtil.shouldSuppress(searchContext) || Validator.isBlank((String)keywords)) {
            return;
        }
        for (String className : classNames) {
            this.contribute(className, booleanQuery, keywords, searchContext);
        }
    }

    @Reference(unbind="-")
    public void setExpandoBridgeFactory(ExpandoBridgeFactory expandoBridgeFactory) {
        this._expandoBridgeFactory = expandoBridgeFactory;
    }

    @Reference(unbind="-")
    public void setExpandoBridgeIndexer(ExpandoBridgeIndexer expandoBridgeIndexer) {
        this._expandoBridgeIndexer = expandoBridgeIndexer;
    }

    @Reference(unbind="-")
    public void setExpandoColumnLocalService(ExpandoColumnLocalService expandoColumnLocalService) {
        this._expandoColumnLocalService = expandoColumnLocalService;
    }

    protected void contribute(String className, BooleanQuery booleanQuery, String keywords, SearchContext searchContext) {
        ExpandoBridge expandoBridge = this._expandoBridgeFactory.getExpandoBridge(searchContext.getCompanyId(), className);
        Set attributeNames = SetUtil.fromEnumeration((Enumeration)expandoBridge.getAttributeNames());
        for (String attributeName : attributeNames) {
            this.contribute(attributeName, expandoBridge, booleanQuery, keywords, searchContext);
        }
    }

    protected void contribute(String attributeName, ExpandoBridge expandoBridge, BooleanQuery booleanQuery, String keywords, SearchContext searchContext) {
        UnicodeProperties unicodeProperties = expandoBridge.getAttributeProperties(attributeName);
        int indexType = GetterUtil.getInteger((String)unicodeProperties.getProperty("index-type"));
        if (indexType == 0) {
            return;
        }
        String fieldName = this._getExpandoFieldName(attributeName, expandoBridge, searchContext.getLocale());
        if (fieldName.endsWith("_geolocation")) {
            return;
        }
        boolean like = false;
        if (indexType == 1) {
            like = true;
        }
        if (searchContext.isAndSearch()) {
            booleanQuery.addRequiredTerm(fieldName, keywords, like);
        } else {
            this._addTerm(booleanQuery, fieldName, keywords, like);
        }
    }

    private Query _addTerm(BooleanQuery booleanQuery, String fieldName, String keywords, boolean like) {
        try {
            return booleanQuery.addTerm(fieldName, keywords, like);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }

    private String _getExpandoFieldName(String attributeName, ExpandoBridge expandoBridge, Locale locale) {
        ExpandoColumn expandoColumn = this._expandoColumnLocalService.getDefaultTableColumn(expandoBridge.getCompanyId(), expandoBridge.getClassName(), attributeName);
        String fieldName = this._expandoBridgeIndexer.encodeFieldName(expandoColumn);
        String numericSuffix = this._expandoBridgeIndexer.getNumericSuffix(expandoColumn.getType());
        if (!numericSuffix.equals("")) {
            fieldName = fieldName.concat(".keyword");
        } else if (expandoColumn.getType() == 20) {
            fieldName = this._getLocalizedName(fieldName, locale);
        } else if (expandoColumn.getType() == 21) {
            fieldName = fieldName.concat("_geolocation");
        }
        return fieldName;
    }

    private Localization _getLocalization() {
        if (this.localization != null) {
            return this.localization;
        }
        return LocalizationUtil.getLocalization();
    }

    private String _getLocalizedName(String name, Locale locale) {
        if (locale == null) {
            return name;
        }
        Localization localization = this._getLocalization();
        return localization.getLocalizedName(name, LocaleUtil.toLanguageId((Locale)locale));
    }
}

