/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.facet;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.collector.DefaultTermCollector;
import com.liferay.portal.kernel.search.facet.collector.FacetCollector;
import com.liferay.portal.kernel.search.facet.collector.TermCollector;
import com.liferay.portal.search.internal.facet.FacetBucketUtil;
import com.liferay.portal.search.internal.facet.SimpleFacetCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class FacetDiscounter {
    private final Map<String, Integer> _excludedTermsMap = new HashMap<String, Integer>();
    private final Facet _facet;

    public FacetDiscounter(Facet facet) {
        this._facet = facet;
    }

    public void discount(Collection<Document> documents) {
        for (Document document : documents) {
            this._exclude(document);
        }
        this._decrement();
    }

    private void _decrement() {
        if (this._excludedTermsMap.isEmpty()) {
            return;
        }
        FacetCollector facetCollector = this._facet.getFacetCollector();
        List termCollectors = facetCollector.getTermCollectors();
        ArrayList<TermCollector> newTermCollectors = new ArrayList<TermCollector>(termCollectors.size());
        for (TermCollector termCollector : termCollectors) {
            String term = termCollector.getTerm();
            int exclusions = this._getExclusions(term);
            int frequency = termCollector.getFrequency() - exclusions;
            if (frequency <= 0) continue;
            newTermCollectors.add((TermCollector)new DefaultTermCollector(term, frequency));
        }
        this._facet.setFacetCollector((FacetCollector)new SimpleFacetCollector(facetCollector.getFieldName(), newTermCollectors));
    }

    private void _exclude(Document document) {
        Field field = document.getField(this._facet.getFieldName());
        if (field == null) {
            return;
        }
        Stream<String> termsStream = this._findTermsOfField(field);
        termsStream.forEach(this::_exclude);
    }

    private void _exclude(String term) {
        int exclusions = this._getExclusions(term);
        this._excludedTermsMap.put(term, exclusions + 1);
    }

    private Stream<String> _findTermsOfField(Field field) {
        FacetCollector facetCollector = this._facet.getFacetCollector();
        List termCollectors = facetCollector.getTermCollectors();
        Stream termCollectorsStream = termCollectors.stream();
        Stream<String> termsStream = termCollectorsStream.map(TermCollector::getTerm);
        return termsStream.filter(term -> FacetBucketUtil.isFieldInBucket(field, term, this._facet));
    }

    private int _getExclusions(String term) {
        Integer exclusions = this._excludedTermsMap.get(term);
        if (exclusions != null) {
            return exclusions;
        }
        return 0;
    }
}

