/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.facet.category;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.facet.category.CategoryFacetFactory;
import com.liferay.portal.search.facet.category.CategoryFacetSearchContributor;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import java.util.function.Consumer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CategoryFacetSearchContributor.class})
public class CategoryFacetSearchContributorImpl
implements CategoryFacetSearchContributor {
    private CategoryFacetFactory _categoryFacetFactory;

    public void contribute(SearchRequestBuilder searchRequestBuilder, Consumer<CategoryFacetSearchContributor.CategoryFacetBuilder> categoryFacetBuilderConsumer) {
        com.liferay.portal.search.facet.Facet facet = (com.liferay.portal.search.facet.Facet)searchRequestBuilder.withSearchContextGet(searchContext -> {
            CategoryFacetBuilderImpl categoryFacetBuilderImpl = new CategoryFacetBuilderImpl((SearchContext)searchContext);
            categoryFacetBuilderConsumer.accept(categoryFacetBuilderImpl);
            return categoryFacetBuilderImpl.build();
        });
        searchRequestBuilder.withFacetContext(facetContext -> facetContext.addFacet((Facet)facet));
    }

    @Reference(unbind="-")
    protected void setCategoryFacetFactory(CategoryFacetFactory categoryFacetFactory) {
        this._categoryFacetFactory = categoryFacetFactory;
    }

    private class CategoryFacetBuilderImpl
    implements CategoryFacetSearchContributor.CategoryFacetBuilder {
        private String _aggregationName;
        private int _frequencyThreshold;
        private int _maxTerms;
        private final SearchContext _searchContext;
        private long[] _selectedCategoryIds;

        public CategoryFacetBuilderImpl(SearchContext searchContext) {
            this._searchContext = searchContext;
        }

        public CategoryFacetSearchContributor.CategoryFacetBuilder aggregationName(String aggregationName) {
            this._aggregationName = aggregationName;
            return this;
        }

        public com.liferay.portal.search.facet.Facet build() {
            com.liferay.portal.search.facet.Facet facet = CategoryFacetSearchContributorImpl.this._categoryFacetFactory.newInstance(this._searchContext);
            facet.setAggregationName(this._aggregationName);
            facet.setFacetConfiguration(this.buildFacetConfiguration(facet));
            if (this._selectedCategoryIds != null) {
                facet.select(ArrayUtil.toStringArray((long[])this._selectedCategoryIds));
            }
            return facet;
        }

        public CategoryFacetSearchContributor.CategoryFacetBuilder frequencyThreshold(int frequencyThreshold) {
            this._frequencyThreshold = frequencyThreshold;
            return this;
        }

        public CategoryFacetSearchContributor.CategoryFacetBuilder maxTerms(int maxTerms) {
            this._maxTerms = maxTerms;
            return this;
        }

        public CategoryFacetSearchContributor.CategoryFacetBuilder selectedCategoryIds(long ... selectedCategoryIds) {
            this._selectedCategoryIds = selectedCategoryIds;
            return this;
        }

        protected FacetConfiguration buildFacetConfiguration(com.liferay.portal.search.facet.Facet facet) {
            FacetConfiguration facetConfiguration = new FacetConfiguration();
            facetConfiguration.setFieldName(facet.getFieldName());
            facetConfiguration.setLabel("any-category");
            facetConfiguration.setOrder("OrderHitsDesc");
            facetConfiguration.setStatic(false);
            facetConfiguration.setWeight(1.6);
            JSONObject jsonObject = facetConfiguration.getData();
            jsonObject.put("frequencyThreshold", this._frequencyThreshold).put("maxTerms", this._maxTerms);
            return facetConfiguration;
        }
    }
}

