/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.facet.folder;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.facet.folder.FolderFacetFactory;
import com.liferay.portal.search.facet.folder.FolderFacetSearchContributor;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import java.util.function.Consumer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FolderFacetSearchContributor.class})
public class FolderFacetSearchContributorImpl
implements FolderFacetSearchContributor {
    private FolderFacetFactory _folderFacetFactory;

    public void contribute(SearchRequestBuilder searchRequestBuilder, Consumer<FolderFacetSearchContributor.FolderFacetBuilder> folderFacetBuilderConsumer) {
        com.liferay.portal.search.facet.Facet facet = (com.liferay.portal.search.facet.Facet)searchRequestBuilder.withSearchContextGet(searchContext -> {
            FolderFacetBuilderImpl folderFacetBuilderImpl = new FolderFacetBuilderImpl((SearchContext)searchContext);
            folderFacetBuilderConsumer.accept(folderFacetBuilderImpl);
            return folderFacetBuilderImpl.build();
        });
        searchRequestBuilder.withFacetContext(facetContext -> facetContext.addFacet((Facet)facet));
    }

    @Reference(unbind="-")
    protected void setFolderFacetFactory(FolderFacetFactory folderFacetFactory) {
        this._folderFacetFactory = folderFacetFactory;
    }

    private class FolderFacetBuilderImpl
    implements FolderFacetSearchContributor.FolderFacetBuilder {
        private String _aggregationName;
        private int _frequencyThreshold;
        private int _maxTerms;
        private final SearchContext _searchContext;
        private long[] _selectedFolderIds;

        public FolderFacetBuilderImpl(SearchContext searchContext) {
            this._searchContext = searchContext;
        }

        public FolderFacetSearchContributor.FolderFacetBuilder aggregationName(String aggregationName) {
            this._aggregationName = aggregationName;
            return this;
        }

        public com.liferay.portal.search.facet.Facet build() {
            com.liferay.portal.search.facet.Facet facet = FolderFacetSearchContributorImpl.this._folderFacetFactory.newInstance(this._searchContext);
            facet.setAggregationName(this._aggregationName);
            facet.setFacetConfiguration(this.buildFacetConfiguration(facet));
            if (this._selectedFolderIds != null) {
                facet.select(ArrayUtil.toStringArray((long[])this._selectedFolderIds));
            }
            return facet;
        }

        public FolderFacetSearchContributor.FolderFacetBuilder frequencyThreshold(int frequencyThreshold) {
            this._frequencyThreshold = frequencyThreshold;
            return this;
        }

        public FolderFacetSearchContributor.FolderFacetBuilder maxTerms(int maxTerms) {
            this._maxTerms = maxTerms;
            return this;
        }

        public FolderFacetSearchContributor.FolderFacetBuilder selectedFolderIds(long ... selectedFolderIds) {
            this._selectedFolderIds = selectedFolderIds;
            return this;
        }

        protected FacetConfiguration buildFacetConfiguration(com.liferay.portal.search.facet.Facet facet) {
            FacetConfiguration facetConfiguration = new FacetConfiguration();
            facetConfiguration.setFieldName(facet.getFieldName());
            facetConfiguration.setLabel("any-folder");
            facetConfiguration.setOrder("OrderHitsDesc");
            facetConfiguration.setStatic(false);
            facetConfiguration.setWeight(1.4);
            JSONObject jsonObject = facetConfiguration.getData();
            jsonObject.put("frequencyThreshold", this._frequencyThreshold).put("maxTerms", this._maxTerms);
            return facetConfiguration;
        }
    }
}

