/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.facet.nested;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.search.aggregation.Aggregations;
import com.liferay.portal.search.facet.nested.NestedFacetFactory;
import com.liferay.portal.search.facet.nested.NestedFacetSearchContributor;
import com.liferay.portal.search.internal.facet.NestedFacetImpl;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import java.util.function.Consumer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={NestedFacetSearchContributor.class})
public class NestedFacetSearchContributorImpl
implements NestedFacetSearchContributor {
    @Reference
    protected Aggregations aggregations;
    @Reference
    protected NestedFacetFactory nestedFacetFactory;
    @Reference
    protected Queries queries;

    public void contribute(SearchRequestBuilder searchRequestBuilder, Consumer<NestedFacetSearchContributor.NestedFacetBuilder> nestedFacetBuilderConsumer) {
        com.liferay.portal.search.facet.Facet facet = (com.liferay.portal.search.facet.Facet)searchRequestBuilder.withSearchContextGet(searchContext -> {
            NestedFacetBuilderImpl nestedFacetBuilderImpl = new NestedFacetBuilderImpl((SearchContext)searchContext);
            nestedFacetBuilderConsumer.accept(nestedFacetBuilderImpl);
            return nestedFacetBuilderImpl.build();
        });
        searchRequestBuilder.withFacetContext(facetContext -> facetContext.addFacet((Facet)facet));
    }

    private class NestedFacetBuilderImpl
    implements NestedFacetSearchContributor.NestedFacetBuilder {
        private String _aggregationName;
        private String _fieldToAggregate;
        private String _filterField;
        private String _filterValue;
        private int _frequencyThreshold;
        private int _maxTerms;
        private String _path;
        private final SearchContext _searchContext;
        private String[] _selectedValues;

        public NestedFacetBuilderImpl(SearchContext searchContext) {
            this._searchContext = searchContext;
        }

        public NestedFacetSearchContributor.NestedFacetBuilder aggregationName(String aggregationName) {
            this._aggregationName = aggregationName;
            return this;
        }

        public com.liferay.portal.search.facet.Facet build() {
            NestedFacetImpl nestedFacetImpl = (NestedFacetImpl)NestedFacetSearchContributorImpl.this.nestedFacetFactory.newInstance(this._searchContext);
            nestedFacetImpl.setAggregationName(this._aggregationName);
            nestedFacetImpl.setFacetConfiguration(this.buildFacetConfiguration(nestedFacetImpl));
            nestedFacetImpl.setFieldName(this._fieldToAggregate);
            nestedFacetImpl.setFilterField(this._filterField);
            nestedFacetImpl.setFilterValue(this._filterValue);
            nestedFacetImpl.setPath(this._path);
            nestedFacetImpl.select(this._selectedValues);
            return nestedFacetImpl;
        }

        public NestedFacetSearchContributor.NestedFacetBuilder fieldToAggregate(String fieldToAggregate) {
            this._fieldToAggregate = fieldToAggregate;
            return this;
        }

        public NestedFacetSearchContributor.NestedFacetBuilder filterField(String filterField) {
            this._filterField = filterField;
            return this;
        }

        public NestedFacetSearchContributor.NestedFacetBuilder filterValue(String filterValue) {
            this._filterValue = filterValue;
            return this;
        }

        public NestedFacetSearchContributor.NestedFacetBuilder frequencyThreshold(int frequencyThreshold) {
            this._frequencyThreshold = frequencyThreshold;
            return this;
        }

        public NestedFacetSearchContributor.NestedFacetBuilder maxTerms(int maxTerms) {
            this._maxTerms = maxTerms;
            return this;
        }

        public NestedFacetSearchContributor.NestedFacetBuilder path(String path) {
            this._path = path;
            return this;
        }

        public NestedFacetSearchContributor.NestedFacetBuilder selectedValues(String ... selectedValues) {
            this._selectedValues = selectedValues;
            return this;
        }

        protected FacetConfiguration buildFacetConfiguration(com.liferay.portal.search.facet.Facet facet) {
            FacetConfiguration facetConfiguration = new FacetConfiguration();
            facetConfiguration.setFieldName(facet.getFieldName());
            facetConfiguration.setOrder("OrderHitsDesc");
            facetConfiguration.setStatic(false);
            facetConfiguration.setWeight(1.1);
            JSONObject jsonObject = facetConfiguration.getData();
            jsonObject.put("frequencyThreshold", this._frequencyThreshold).put("maxTerms", this._maxTerms);
            return facetConfiguration;
        }
    }
}

