/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.facet.site;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.facet.site.SiteFacetFactory;
import com.liferay.portal.search.facet.site.SiteFacetSearchContributor;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import java.util.function.Consumer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SiteFacetSearchContributor.class})
public class SiteFacetSearchContributorImpl
implements SiteFacetSearchContributor {
    private SiteFacetFactory _siteFacetFactory;

    public void contribute(SearchRequestBuilder searchRequestBuilder, Consumer<SiteFacetSearchContributor.SiteFacetBuilder> siteFacetBuilderConsumer) {
        com.liferay.portal.search.facet.Facet facet = (com.liferay.portal.search.facet.Facet)searchRequestBuilder.withSearchContextGet(searchContext -> {
            SiteFacetBuilderImpl siteFacetBuilderImpl = new SiteFacetBuilderImpl((SearchContext)searchContext);
            siteFacetBuilderConsumer.accept(siteFacetBuilderImpl);
            return siteFacetBuilderImpl.build();
        });
        searchRequestBuilder.withFacetContext(facetContext -> facetContext.addFacet((Facet)facet));
    }

    @Reference(unbind="-")
    protected void setSiteFacetFactory(SiteFacetFactory siteFacetFactory) {
        this._siteFacetFactory = siteFacetFactory;
    }

    private class SiteFacetBuilderImpl
    implements SiteFacetSearchContributor.SiteFacetBuilder {
        private String _aggregationName;
        private int _frequencyThreshold;
        private int _maxTerms;
        private final SearchContext _searchContext;
        private String[] _selectedGroupIds;

        public SiteFacetBuilderImpl(SearchContext searchContext) {
            this._searchContext = searchContext;
        }

        public SiteFacetSearchContributor.SiteFacetBuilder aggregationName(String aggregationName) {
            this._aggregationName = aggregationName;
            return this;
        }

        public com.liferay.portal.search.facet.Facet build() {
            com.liferay.portal.search.facet.Facet facet = SiteFacetSearchContributorImpl.this._siteFacetFactory.newInstance(this._searchContext);
            facet.setAggregationName(this._aggregationName);
            facet.setFacetConfiguration(this.buildFacetConfiguration(facet));
            if (ArrayUtil.isNotEmpty((Object[])this._selectedGroupIds)) {
                facet.select(this._selectedGroupIds);
            }
            return facet;
        }

        public SiteFacetSearchContributor.SiteFacetBuilder frequencyThreshold(int frequencyThreshold) {
            this._frequencyThreshold = frequencyThreshold;
            return this;
        }

        public SiteFacetSearchContributor.SiteFacetBuilder maxTerms(int maxTerms) {
            this._maxTerms = maxTerms;
            return this;
        }

        public SiteFacetSearchContributor.SiteFacetBuilder selectedGroupIds(String ... selectedGroupIds) {
            this._selectedGroupIds = selectedGroupIds;
            return this;
        }

        protected FacetConfiguration buildFacetConfiguration(com.liferay.portal.search.facet.Facet facet) {
            FacetConfiguration facetConfiguration = new FacetConfiguration();
            facetConfiguration.setFieldName(facet.getFieldName());
            facetConfiguration.setLabel("any-site");
            facetConfiguration.setOrder("OrderHitsDesc");
            facetConfiguration.setStatic(false);
            facetConfiguration.setWeight(1.6);
            JSONObject jsonObject = facetConfiguration.getData();
            jsonObject.put("frequencyThreshold", this._frequencyThreshold).put("maxTerms", this._maxTerms);
            return facetConfiguration;
        }
    }
}

