/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.facet.tag;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.search.facet.tag.AssetTagNamesFacetFactory;
import com.liferay.portal.search.facet.tag.TagFacetSearchContributor;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import java.util.function.Consumer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={TagFacetSearchContributor.class})
public class TagFacetSearchContributorImpl
implements TagFacetSearchContributor {
    private AssetTagNamesFacetFactory _assetTagNamesFacetFactory;

    public void contribute(SearchRequestBuilder searchRequestBuilder, Consumer<TagFacetSearchContributor.TagFacetBuilder> tagFacetBuilderConsumer) {
        com.liferay.portal.search.facet.Facet facet = (com.liferay.portal.search.facet.Facet)searchRequestBuilder.withSearchContextGet(searchContext -> {
            TagFacetBuilderImpl tagFacetBuilderImpl = new TagFacetBuilderImpl((SearchContext)searchContext);
            tagFacetBuilderConsumer.accept(tagFacetBuilderImpl);
            return tagFacetBuilderImpl.build();
        });
        searchRequestBuilder.withFacetContext(facetContext -> facetContext.addFacet((Facet)facet));
    }

    @Reference(unbind="-")
    protected void setAssetTagNamesFacetFactory(AssetTagNamesFacetFactory assetTagNamesFacetFactory) {
        this._assetTagNamesFacetFactory = assetTagNamesFacetFactory;
    }

    private class TagFacetBuilderImpl
    implements TagFacetSearchContributor.TagFacetBuilder {
        private String _aggregationName;
        private int _frequencyThreshold;
        private int _maxTerms;
        private final SearchContext _searchContext;
        private String[] _selectedTagNames;

        public TagFacetBuilderImpl(SearchContext searchContext) {
            this._searchContext = searchContext;
        }

        public TagFacetSearchContributor.TagFacetBuilder aggregationName(String aggregationName) {
            this._aggregationName = aggregationName;
            return this;
        }

        public com.liferay.portal.search.facet.Facet build() {
            com.liferay.portal.search.facet.Facet facet = TagFacetSearchContributorImpl.this._assetTagNamesFacetFactory.newInstance(this._searchContext);
            facet.setAggregationName(this._aggregationName);
            facet.setFacetConfiguration(this.buildFacetConfiguration(facet));
            facet.select(this._selectedTagNames);
            return facet;
        }

        public TagFacetSearchContributor.TagFacetBuilder frequencyThreshold(int frequencyThreshold) {
            this._frequencyThreshold = frequencyThreshold;
            return this;
        }

        public TagFacetSearchContributor.TagFacetBuilder maxTerms(int maxTerms) {
            this._maxTerms = maxTerms;
            return this;
        }

        public TagFacetSearchContributor.TagFacetBuilder selectedTagNames(String ... selectedTagNames) {
            this._selectedTagNames = selectedTagNames;
            return this;
        }

        protected FacetConfiguration buildFacetConfiguration(com.liferay.portal.search.facet.Facet facet) {
            FacetConfiguration facetConfiguration = new FacetConfiguration();
            facetConfiguration.setFieldName(facet.getFieldName());
            facetConfiguration.setLabel("any-tag");
            facetConfiguration.setOrder("OrderHitsDesc");
            facetConfiguration.setStatic(false);
            facetConfiguration.setWeight(1.4);
            JSONObject jsonObject = facetConfiguration.getData();
            jsonObject.put("frequencyThreshold", this._frequencyThreshold).put("maxTerms", this._maxTerms);
            return facetConfiguration;
        }
    }
}

