/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.facet.type;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.search.facet.type.AssetEntriesFacetFactory;
import com.liferay.portal.search.facet.type.TypeFacetSearchContributor;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import java.util.function.Consumer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={TypeFacetSearchContributor.class})
public class TypeFacetSearchContributorImpl
implements TypeFacetSearchContributor {
    private AssetEntriesFacetFactory _assetEntriesFacetFactory;

    public void contribute(SearchRequestBuilder searchRequestBuilder, Consumer<TypeFacetSearchContributor.TypeFacetBuilder> typeFacetBuilderConsumer) {
        com.liferay.portal.search.facet.Facet facet = (com.liferay.portal.search.facet.Facet)searchRequestBuilder.withSearchContextGet(searchContext -> {
            TypeFacetBuilderImpl typeFacetBuilderImpl = new TypeFacetBuilderImpl((SearchContext)searchContext);
            typeFacetBuilderConsumer.accept(typeFacetBuilderImpl);
            return typeFacetBuilderImpl.build();
        });
        searchRequestBuilder.withFacetContext(facetContext -> facetContext.addFacet((Facet)facet));
    }

    @Reference(unbind="-")
    protected void setAssetEntriesFacetFactory(AssetEntriesFacetFactory assetEntriesFacetFactory) {
        this._assetEntriesFacetFactory = assetEntriesFacetFactory;
    }

    private class TypeFacetBuilderImpl
    implements TypeFacetSearchContributor.TypeFacetBuilder {
        private String _aggregationName;
        private int _frequencyThreshold;
        private final SearchContext _searchContext;
        private String[] _selectedEntryClassNames;

        public TypeFacetBuilderImpl(SearchContext searchContext) {
            this._searchContext = searchContext;
        }

        public TypeFacetSearchContributor.TypeFacetBuilder aggregationName(String portletId) {
            this._aggregationName = portletId;
            return this;
        }

        public com.liferay.portal.search.facet.Facet build() {
            com.liferay.portal.search.facet.Facet facet = TypeFacetSearchContributorImpl.this._assetEntriesFacetFactory.newInstance(this._searchContext);
            facet.setAggregationName(this._aggregationName);
            facet.setFacetConfiguration(this.buildFacetConfiguration(facet));
            facet.select(this._selectedEntryClassNames);
            return facet;
        }

        public TypeFacetSearchContributor.TypeFacetBuilder frequencyThreshold(int frequencyThreshold) {
            this._frequencyThreshold = frequencyThreshold;
            return this;
        }

        public TypeFacetSearchContributor.TypeFacetBuilder selectedEntryClassNames(String ... selectedEntryClassNames) {
            this._selectedEntryClassNames = selectedEntryClassNames;
            return this;
        }

        protected FacetConfiguration buildFacetConfiguration(com.liferay.portal.search.facet.Facet facet) {
            FacetConfiguration facetConfiguration = new FacetConfiguration();
            facetConfiguration.setFieldName(facet.getFieldName());
            facetConfiguration.setLabel("any-asset");
            facetConfiguration.setOrder("OrderHitsDesc");
            facetConfiguration.setStatic(false);
            facetConfiguration.setWeight(1.6);
            JSONObject jsonObject = facetConfiguration.getData();
            jsonObject.put("frequencyThreshold", this._frequencyThreshold);
            return facetConfiguration;
        }
    }
}

