/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.facet.user;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.search.facet.user.UserFacetFactory;
import com.liferay.portal.search.facet.user.UserFacetSearchContributor;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import java.util.function.Consumer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={UserFacetSearchContributor.class})
public class UserFacetSearchContributorImpl
implements UserFacetSearchContributor {
    private UserFacetFactory _userFacetFactory;

    public void contribute(SearchRequestBuilder searchRequestBuilder, Consumer<UserFacetSearchContributor.UserFacetBuilder> userFacetBuilderConsumer) {
        com.liferay.portal.search.facet.Facet facet = (com.liferay.portal.search.facet.Facet)searchRequestBuilder.withSearchContextGet(searchContext -> {
            UserFacetBuilderImpl userFacetBuilderImpl = new UserFacetBuilderImpl((SearchContext)searchContext);
            userFacetBuilderConsumer.accept(userFacetBuilderImpl);
            return userFacetBuilderImpl.build();
        });
        searchRequestBuilder.withFacetContext(facetContext -> facetContext.addFacet((Facet)facet));
    }

    @Reference(unbind="-")
    protected void setUserFacetFactory(UserFacetFactory userFacetFactory) {
        this._userFacetFactory = userFacetFactory;
    }

    private class UserFacetBuilderImpl
    implements UserFacetSearchContributor.UserFacetBuilder {
        private String _aggregationName;
        private int _frequencyThreshold;
        private int _maxTerms;
        private final SearchContext _searchContext;
        private String[] _selectedUserNames;

        public UserFacetBuilderImpl(SearchContext searchContext) {
            this._searchContext = searchContext;
        }

        public UserFacetSearchContributor.UserFacetBuilder aggregationName(String aggregationName) {
            this._aggregationName = aggregationName;
            return this;
        }

        public com.liferay.portal.search.facet.Facet build() {
            com.liferay.portal.search.facet.Facet facet = UserFacetSearchContributorImpl.this._userFacetFactory.newInstance(this._searchContext);
            facet.setAggregationName(this._aggregationName);
            facet.setFacetConfiguration(this.buildFacetConfiguration(facet));
            facet.select(this._selectedUserNames);
            return facet;
        }

        public UserFacetSearchContributor.UserFacetBuilder frequencyThreshold(int frequencyThreshold) {
            this._frequencyThreshold = frequencyThreshold;
            return this;
        }

        public UserFacetSearchContributor.UserFacetBuilder maxTerms(int maxTerms) {
            this._maxTerms = maxTerms;
            return this;
        }

        public UserFacetSearchContributor.UserFacetBuilder selectedUserNames(String ... selectedUserNames) {
            this._selectedUserNames = selectedUserNames;
            return this;
        }

        protected FacetConfiguration buildFacetConfiguration(com.liferay.portal.search.facet.Facet facet) {
            FacetConfiguration facetConfiguration = new FacetConfiguration();
            facetConfiguration.setFieldName(facet.getFieldName());
            facetConfiguration.setLabel("any-user");
            facetConfiguration.setOrder("OrderHitsDesc");
            facetConfiguration.setStatic(false);
            facetConfiguration.setWeight(1.1);
            JSONObject jsonObject = facetConfiguration.getData();
            jsonObject.put("frequencyThreshold", this._frequencyThreshold).put("maxTerms", this._maxTerms);
            return facetConfiguration;
        }
    }
}

