/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.filter;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.filter.ComplexQueryBuilder;
import com.liferay.portal.search.filter.ComplexQueryPart;
import com.liferay.portal.search.internal.filter.range.RangeTermQueryValue;
import com.liferay.portal.search.internal.filter.range.RangeTermQueryValueParser;
import com.liferay.portal.search.internal.util.SearchStringUtil;
import com.liferay.portal.search.query.BooleanQuery;
import com.liferay.portal.search.query.NestedQuery;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.SimpleStringQuery;
import com.liferay.portal.search.query.StringQuery;
import com.liferay.portal.search.script.Scripts;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ComplexQueryBuilderImpl
implements ComplexQueryBuilder {
    private BooleanQuery _booleanQuery;
    private final List<ComplexQueryPart> _complexQueryParts = new ArrayList<ComplexQueryPart>();
    private final Queries _queries;
    private final Scripts _scripts;

    public ComplexQueryBuilderImpl(Queries queries, Scripts scripts) {
        this._queries = queries;
        this._scripts = scripts;
    }

    public ComplexQueryBuilder addParts(Collection<ComplexQueryPart> complexQueryParts) {
        this._complexQueryParts.addAll(complexQueryParts);
        return this;
    }

    public Query build() {
        Stream stream = this._complexQueryParts.stream();
        Map<String, ComplexQueryPart> complexQueryPartsMap = stream.filter(filterQueryDefinition -> !Validator.isBlank((String)filterQueryDefinition.getName())).collect(Collectors.toMap(ComplexQueryPart::getName, Function.identity()));
        Build build = new Build(complexQueryPartsMap, this._getRootBooleanQuery());
        return build.build();
    }

    public ComplexQueryBuilder root(BooleanQuery booleanQuery) {
        this._booleanQuery = booleanQuery;
        return this;
    }

    private BooleanQuery _getRootBooleanQuery() {
        if (this._booleanQuery != null) {
            return this._booleanQuery;
        }
        return this._queries.booleanQuery();
    }

    private class Build {
        private final Map<String, ComplexQueryPart> _complexQueryPartsMap;
        private final Map<String, Query> _queriesMap = new HashMap<String, Query>();
        private final RangeTermQueryValueParser _rangeTermQueryParser = new RangeTermQueryValueParser();
        private final BooleanQuery _rootBooleanQuery;

        public Build(Map<String, ComplexQueryPart> complexQueryPartsMap, BooleanQuery rootBooleanQuery) {
            this._complexQueryPartsMap = complexQueryPartsMap;
            this._rootBooleanQuery = rootBooleanQuery;
        }

        public Query build() {
            ComplexQueryBuilderImpl.this._complexQueryParts.forEach(this::hydrate);
            return this.getRootBooleanQuery();
        }

        protected Query addQuery(ComplexQueryPart complexQueryPart) {
            Query query = this.getQuery(complexQueryPart);
            if (query == null) {
                return null;
            }
            this.addQueryClause(this.getParentBooleanQuery(complexQueryPart.getParent()), complexQueryPart.getOccur(), query);
            return query;
        }

        protected void addQueryClause(BooleanQuery booleanQuery, String occur, Query query) {
            if (Validator.isBlank((String)occur) || occur.equals("filter")) {
                booleanQuery.addFilterQueryClauses(new Query[]{query});
            } else if (Objects.equals("must", occur)) {
                booleanQuery.addMustQueryClauses(new Query[]{query});
            } else if (Objects.equals("must_not", occur)) {
                booleanQuery.addMustNotQueryClauses(new Query[]{query});
            } else if (Objects.equals("should", occur)) {
                booleanQuery.addShouldQueryClauses(new Query[]{query});
            }
        }

        protected Query buildQuery(String type, String field, String value) {
            if (Objects.equals(type, "bool")) {
                return ComplexQueryBuilderImpl.this._queries.booleanQuery();
            }
            if (Objects.equals(type, "date_range")) {
                RangeTermQueryValue rangeTermQueryValue = this._rangeTermQueryParser.parse(value);
                if (rangeTermQueryValue == null) {
                    return null;
                }
                return ComplexQueryBuilderImpl.this._queries.dateRangeTerm(field, rangeTermQueryValue.isIncludesLower(), rangeTermQueryValue.isIncludesUpper(), rangeTermQueryValue.getLowerBound(), rangeTermQueryValue.getUpperBound());
            }
            if (Objects.equals(type, "exists")) {
                return ComplexQueryBuilderImpl.this._queries.exists(field);
            }
            if (Objects.equals(type, "fuzzy")) {
                if (Validator.isBlank((String)value)) {
                    return null;
                }
                return ComplexQueryBuilderImpl.this._queries.fuzzy(field, value);
            }
            if (Objects.equals(type, "match")) {
                if (Validator.isBlank((String)value)) {
                    return null;
                }
                return ComplexQueryBuilderImpl.this._queries.match(field, (Object)value);
            }
            if (Objects.equals(type, "match_phrase")) {
                if (Validator.isBlank((String)value)) {
                    return null;
                }
                return ComplexQueryBuilderImpl.this._queries.matchPhrase(field, (Object)value);
            }
            if (Objects.equals(type, "match_phrase_prefix")) {
                if (Validator.isBlank((String)value)) {
                    return null;
                }
                return ComplexQueryBuilderImpl.this._queries.matchPhrasePrefix(field, (Object)value);
            }
            if (Objects.equals(type, "multi_match")) {
                if (Validator.isBlank((String)value)) {
                    return null;
                }
                return ComplexQueryBuilderImpl.this._queries.multiMatch((Object)value, SearchStringUtil.splitAndUnquote(field));
            }
            if (Objects.equals(type, "nested")) {
                return ComplexQueryBuilderImpl.this._queries.nested(field, (Query)ComplexQueryBuilderImpl.this._queries.booleanQuery());
            }
            if (Objects.equals(type, "prefix")) {
                if (Validator.isBlank((String)value)) {
                    return null;
                }
                return ComplexQueryBuilderImpl.this._queries.prefix(field, value);
            }
            if (Objects.equals(type, "query_string")) {
                if (Validator.isBlank((String)value)) {
                    return null;
                }
                StringQuery stringQuery = ComplexQueryBuilderImpl.this._queries.string(value);
                if (!Validator.isBlank((String)field)) {
                    stringQuery.setDefaultField(field);
                }
                return stringQuery;
            }
            if (Objects.equals(type, "range")) {
                RangeTermQueryValue rangeTermQueryValue = this._rangeTermQueryParser.parse(value);
                if (rangeTermQueryValue == null) {
                    return null;
                }
                return ComplexQueryBuilderImpl.this._queries.rangeTerm(field, rangeTermQueryValue.isIncludesLower(), rangeTermQueryValue.isIncludesUpper(), (Object)rangeTermQueryValue.getLowerBound(), (Object)rangeTermQueryValue.getUpperBound());
            }
            if (Objects.equals(type, "regexp")) {
                if (Validator.isBlank((String)value)) {
                    return null;
                }
                return ComplexQueryBuilderImpl.this._queries.regex(field, value);
            }
            if (Objects.equals(type, "script")) {
                if (Validator.isBlank((String)value)) {
                    return null;
                }
                return ComplexQueryBuilderImpl.this._queries.script(ComplexQueryBuilderImpl.this._scripts.script(value));
            }
            if (Objects.equals(type, "simple_query_string")) {
                if (Validator.isBlank((String)value)) {
                    return null;
                }
                SimpleStringQuery simpleStringQuery = ComplexQueryBuilderImpl.this._queries.simpleString(value);
                if (!Validator.isBlank((String)field)) {
                    simpleStringQuery.addFields(new String[]{field});
                }
                return simpleStringQuery;
            }
            if (Objects.equals(type, "term")) {
                if (Validator.isBlank((String)value)) {
                    return null;
                }
                return ComplexQueryBuilderImpl.this._queries.term(field, (Object)value);
            }
            if (Objects.equals(type, "wildcard")) {
                if (Validator.isBlank((String)value)) {
                    return null;
                }
                return ComplexQueryBuilderImpl.this._queries.wildcard(field, value);
            }
            return null;
        }

        protected Query getNamedQuery(String name) {
            return this._queriesMap.get(name);
        }

        protected BooleanQuery getParentBooleanQuery(String parent) {
            ComplexQueryPart complexQueryPart;
            if (!Validator.isBlank((String)parent) && (complexQueryPart = this._complexQueryPartsMap.get(parent)) != null) {
                Query query = this.hydrate(complexQueryPart);
                if (query instanceof NestedQuery) {
                    NestedQuery nestedQuery = (NestedQuery)query;
                    query = nestedQuery.getQuery();
                }
                if (query instanceof BooleanQuery) {
                    return (BooleanQuery)query;
                }
            }
            return this.getRootBooleanQuery();
        }

        protected Query getQuery(ComplexQueryPart complexQueryPart) {
            String value;
            String field;
            if (complexQueryPart.isDisabled()) {
                return null;
            }
            if (complexQueryPart.getQuery() != null) {
                return complexQueryPart.getQuery();
            }
            String type = GetterUtil.getString((String)complexQueryPart.getType());
            Query query = this.buildQuery(type, field = GetterUtil.getString((String)complexQueryPart.getField()), value = GetterUtil.getString((String)complexQueryPart.getValue()));
            if (query == null) {
                return null;
            }
            query.setBoost(complexQueryPart.getBoost());
            query.setQueryName(complexQueryPart.getName());
            return query;
        }

        protected BooleanQuery getRootBooleanQuery() {
            return this._rootBooleanQuery;
        }

        protected Query hydrate(ComplexQueryPart complexQueryPart) {
            Query query = this.getNamedQuery(complexQueryPart.getName());
            if (query != null) {
                return query;
            }
            return this.putNamedQuery(complexQueryPart.getName(), this.addQuery(complexQueryPart));
        }

        protected Query putNamedQuery(String name, Query query) {
            if (Validator.isBlank((String)name)) {
                return query;
            }
            this._queriesMap.put(name, query);
            return query;
        }
    }
}

